/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.regression.linear.heteroskedasticity;

import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.Residuals;
import com.numericalmethod.suanshu.stats.regression.linear.ols.OLSRegression;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public abstract class Heteroskedasticity
extends HypothesisTest {
    public final Residuals residuals;
    public final int n;

    @Override
    public double statistics() {
        OLSRegression a2 = this.getAuxiliaryRegression();
        return (double)this.n * a2.residuals.R2;
    }

    public Heteroskedasticity(Residuals a2) {
        super(new double[0][]);
        Heteroskedasticity a3;
        a3.residuals = a2;
        a3.n = a2.problem.nObs();
    }

    @Override
    public String getNullHypothesis() {
        return "there is homoskedasticity";
    }

    @Override
    public String getAlternativeHypothesis() {
        return "there is conditional heteroscedasticity";
    }

    @Override
    public double pValue() {
        return Heteroskedasticity.oneSidedPvalue(this.getX2(), this.statistics());
    }

    public abstract OLSRegression getAuxiliaryRegression();

    public OLSRegression getAuxiliaryOLSRegression(Vector y, Residuals residuals) {
        LMProblem a2 = new LMProblem(y, residuals.problem.X(), true);
        return new OLSRegression(a2);
    }

    public ChiSquareDistribution getX2() {
        return new ChiSquareDistribution(this.residuals.problem.nExogenousFactors());
    }
}

