/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.rank.wilcoxon;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.Counter;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.descriptive.rank.Rank;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.rank.wilcoxon.WilcoxonSignedRankDistribution;
import java.util.Iterator;

public class WilcoxonSignedRank
extends HypothesisTest {
    public final double pValue1SidedLess;
    public final double pValue1SidedGreater;

    public WilcoxonSignedRank(double[] sample1, double[] sample2, double mu, boolean isExact) {
        int a2;
        int a3;
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = sample1;
        dArrayArray[1] = sample2;
        super(dArrayArray);
        SuanShuUtils.assertArgument(sample2 == null || sample2.length == sample1.length, "the two samples must have equal number of observations", new Object[0]);
        SuanShuUtils.assertArgument(sample1.length > 1, "each sample must have more than 1 observation", new Object[0]);
        int a4 = sample1.length;
        double[] a5 = new double[a4];
        int n = a3 = 0;
        while (n < a4) {
            a5[a3] = sample1[a3] - (sample2 != null ? sample2[a3] : 0.0) - mu;
            n = ++a3;
        }
        double[] a22 = DoubleArrayMath.abs(a5);
        double[] a6 = new Rank(a22).ranks();
        double a7 = 0.0;
        int n2 = a2 = 0;
        while (n2 < a4) {
            a7 += a6[a2] * (double)(a5[a2] > 0.0 ? 1 : 0);
            n2 = ++a2;
        }
        this.testStatistics = a7;
        if (isExact) {
            WilcoxonSignedRankDistribution a8 = new WilcoxonSignedRankDistribution(a4);
            this.pValue1SidedLess = a8.cdf(this.testStatistics);
            this.pValue1SidedGreater = a8.pValue1SidedGreater(this.testStatistics);
            this.pValue = a8.pValue(this.testStatistics);
        } else {
            Iterator<Double> a9;
            Counter a10 = new Counter();
            a10.add(a5);
            int a11 = 0;
            Iterator<Double> iterator = a9 = a10.keySet().iterator();
            while (iterator.hasNext()) {
                Double a12 = a9.next();
                int a13 = a10.count(a12);
                a11 += a13 * (a13 - 1) * (a13 + 1);
                iterator = a9;
            }
            double a32 = (double)a4 * ((double)a4 + 1.0) / 4.0;
            double a14 = Math.sqrt(((double)(a4 * (a4 + 1)) * ((double)(2 * a4) + 1.0) - 0.5 * (double)a11) / 24.0);
            double a15 = (this.testStatistics - a32) / a14;
            NormalDistribution a16 = new NormalDistribution(0.0, 1.0);
            this.pValue1SidedGreater = WilcoxonSignedRank.oneSidedPvalue(a16, a15);
            this.pValue1SidedLess = 1.0 - this.pValue1SidedGreater;
            this.pValue = 2.0 * Math.min(this.pValue1SidedGreater, this.pValue1SidedLess);
        }
    }

    @Override
    public String getNullHypothesis() {
        return "the median are equal (by offset mu)";
    }

    public WilcoxonSignedRank(double[] sample, int mu) {
        this(sample, null, mu, sample.length < 50);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the medians are different (not by mu)";
    }

    public WilcoxonSignedRank(double[] sample1, double[] sample2) {
        this(sample1, sample2, 0.0, sample1.length + sample2.length < 50);
    }

    public WilcoxonSignedRank(double[] sample) {
        this(sample, 0);
    }
}

