/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.mean;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.distribution.univariate.TDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;

public class T
extends HypothesisTest {
    public final UnivariateDistribution T;
    public final double mean1;
    public final double df;
    public final double pValue1SidedLess;
    public final double var2;
    public final double mean2;
    public final double var1;
    private int L;
    private int E;
    public final double pValue1SidedGreater;

    @Override
    public String getAlternativeHypothesis() {
        return "the means are different";
    }

    public double leftConfidenceInterval(double confidence) {
        SuanShuUtils.assertArgument(0.0 < confidence && confidence < 1.0, "0 < confidence level < 1", new Object[0]);
        return this.mean1 - this.mean2 + this.T.quantile(0.95) * Math.sqrt(this.var1 / (double)this.L + this.var2 / (double)this.E);
    }

    @Override
    public String getNullHypothesis() {
        return "the means are equal";
    }

    public double[] confidenceInterval(double confidence) {
        SuanShuUtils.assertArgument(0.0 < confidence && confidence < 1.0, "0 < confidence level < 1", new Object[0]);
        double[] dArray = new double[2];
        double[] a2 = dArray;
        dArray[0] = this.mean1 - this.mean2 - this.T.quantile(0.975) * Math.sqrt(this.var1 / (double)this.L + this.var2 / (double)this.E);
        a2[1] = this.mean1 - this.mean2 + this.T.quantile(0.975) * Math.sqrt(this.var1 / (double)this.L + this.var2 / (double)this.E);
        return a2;
    }

    public T(double[] sample1, double[] sample2) {
        this(sample1, sample2, false, 0.0);
    }

    public T(double[] sample1, double[] sample2, boolean isEqualVar, double mu) {
        super(new double[0][]);
        this.L = sample1.length;
        this.E = sample2.length;
        this.mean1 = new Mean(sample1).value();
        this.var1 = new Variance(sample1).value();
        this.mean2 = new Mean(sample2).value();
        this.var2 = new Variance(sample2).value();
        if (isEqualVar) {
            double a2 = ((double)(this.L - 1) * this.var1 + (double)(this.E - 1) * this.var2) / (double)(this.L + this.E - 2);
            a2 = Math.sqrt(a2);
            this.testStatistics = (this.mean1 - this.mean2 - mu) / a2 / Math.sqrt(1.0 / (double)this.L + (this.E == 1 ? 0.0 : 1.0 / (double)this.E));
            this.df = this.L + this.E - 2;
        } else {
            this.testStatistics = (this.mean1 - this.mean2 - mu) / Math.sqrt(this.var1 / (double)this.L + this.var2 / (double)this.E);
            double a3 = this.var1 / (double)this.L + this.var2 / (double)this.E;
            a3 *= a3;
            this.df = a3 /= Math.pow(this.var1 / (double)this.L, 2.0) / (double)(this.L - 1) + Math.pow(this.var2 / (double)this.E, 2.0) / (double)(this.E - 1);
        }
        this.T = new TDistribution(this.df);
        this.pValue1SidedGreater = com.numericalmethod.suanshu.stats.test.mean.T.oneSidedPvalue(this.T, this.testStatistics);
        this.pValue1SidedLess = this.T.cdf(this.testStatistics);
        this.pValue = 2.0 * Math.min(this.pValue1SidedGreater, this.pValue1SidedLess);
    }

    public T(double[] sample1, double[] sample2, double mu) {
        this(sample1, sample2, false, mu);
    }

    public T(double[] sample, double mu) {
        double[] dArray = new double[1];
        dArray[0] = 0.0;
        this(sample, dArray, true, mu);
    }

    public double rightConfidenceInterval(double confidence) {
        SuanShuUtils.assertArgument(0.0 < confidence && confidence < 1.0, "0 < confidence level < 1", new Object[0]);
        return this.mean1 - this.mean2 - this.T.quantile(0.95) * Math.sqrt(this.var1 / (double)this.L + this.var2 / (double)this.E);
    }
}

