/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test.distribution.pearson;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.distribution.univariate.ChiSquareDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import com.numericalmethod.suanshu.stats.test.HypothesisTest;
import com.numericalmethod.suanshu.stats.test.distribution.pearson.FisherExactDistribution;

public class ChiSquare4Independence
extends HypothesisTest {
    public ChiSquare4Independence(Matrix sample, int nSim, Type type) {
        double[][] dArrayArray = new double[1][];
        dArrayArray[0] = MatrixUtils.to1DArray(sample);
        super(dArrayArray);
        int[] a2 = MatrixUtils.rowSums(sample);
        int[] a3 = MatrixUtils.colSums(sample);
        Matrix a4 = ChiSquare4Independence.getExpectedContingencyTable(a2, a3);
        this.testStatistics = ChiSquare4Independence.pearsonStat(sample, a4, type == Type.ASYMPTOTIC_CHI_SQUARE);
        int a5 = (sample.nRows() - 1) * (sample.nCols() - 1);
        UnivariateDistribution a6 = new ChiSquareDistribution(a5);
        if (type == Type.EXACT) {
            a6 = new FisherExactDistribution(a2, a3, nSim);
        }
        this.pValue = ChiSquare4Independence.oneSidedPvalue(a6, this.testStatistics);
    }

    public static double pearsonStat(Matrix O, Matrix E, boolean YatesContinuityCorrection) {
        int a2;
        int a3 = O.nRows();
        int a4 = O.nCols();
        double a5 = YatesContinuityCorrection ? 0.5 : 0.0;
        double a6 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            int a7;
            int n2 = a7 = 1;
            while (n2 <= a4) {
                double a8 = O.get(a2, a7);
                double a9 = E.get(a2, a7);
                double a10 = Math.abs(a8 - a9) - a5;
                a6 += a10 * a10 / a9;
                n2 = ++a7;
            }
            n = ++a2;
        }
        return a6;
    }

    public static Matrix getExpectedContingencyTable(int[] rowSums, int[] colSums) {
        int a2;
        int a3 = rowSums.length;
        int a4 = colSums.length;
        int a5 = DoubleArrayMath.sum(rowSums);
        DenseMatrix a6 = new DenseMatrix(a3, a4);
        int n = a2 = 1;
        while (n <= a3) {
            int a7;
            int n2 = a7 = 1;
            while (n2 <= a4) {
                a6.set(a2, a7, (double)(rowSums[a2 - 1] * colSums[a7 - 1]) / (double)a5);
                n2 = ++a7;
            }
            n = ++a2;
        }
        return a6;
    }

    @Override
    public String getNullHypothesis() {
        return "the two random variables in the contingency table are independent";
    }

    public ChiSquare4Independence(Matrix sample) {
        this(sample, 0, Type.ASYMPTOTIC_CHI_SQUARE);
    }

    @Override
    public String getAlternativeHypothesis() {
        return "the two random variables in the contingency table are not independent";
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type EXACT = new Type();
        private static final /* synthetic */ Type[] E;
        public static final /* enum */ Type ASYMPTOTIC_CHI_SQUARE = new Type();

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        static {
            Type[] typeArray = new Type[2];
            typeArray[0] = EXACT;
            typeArray[1] = ASYMPTOTIC_CHI_SQUARE;
            E = typeArray;
        }

        public static Type[] values() {
            return (Type[])E.clone();
        }

        private Type() {
            Type a2;
        }
    }
}

