/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.test;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.stats.distribution.univariate.EmpiricalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public abstract class HypothesisTest {
    public final int N;
    public volatile double pValue;
    public final int k;
    public volatile double testStatistics;

    public boolean isNullRejected(double alpha) {
        return this.pValue() < alpha;
    }

    public double statistics() {
        return this.testStatistics;
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    public double pValue() {
        return this.pValue;
    }

    public static double oneSidedPvalue(UnivariateDistribution F2, double x) {
        if (F2 instanceof EmpiricalDistribution) {
            return 1.0 - F2.cdf(x) + F2.density(x);
        }
        return 1.0 - F2.cdf(x);
    }

    public HypothesisTest(double[] ... samples) {
        int a2;
        this.k = samples.length;
        int a3 = 0;
        int n = a2 = 0;
        while (n < this.k) {
            a3 += samples[a2] != null ? samples[a2].length : 0;
            n = ++a2;
        }
        this.N = a3;
    }

    public abstract String getNullHypothesis();

    public abstract String getAlternativeHypothesis();
}

