/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.timeseries.univariate.TimeSeries;
import java.util.Arrays;
import java.util.Iterator;

public class Filtration {
    private double[] F;
    private double[] k;
    private double[] L;
    private double[] E;

    public double[] Bt() {
        return Arrays.copyOf(this.F, this.E.length);
    }

    public Filtration(TimeSeries<Double, ? extends TimeSeries.Entry<Double>> Bt2) {
        Iterator a2;
        int a3 = Bt2.size();
        this.L = new double[a3];
        this.F = new double[a3];
        int a4 = 0;
        Iterator iterator = a2 = Bt2.iterator();
        while (iterator.hasNext()) {
            TimeSeries.Entry a5 = (TimeSeries.Entry)a2.next();
            this.L[a4] = (Double)a5.getTime();
            this.F[a4] = a5.getValue();
            ++a4;
            iterator = a2;
        }
        this.E = R.diff(this.F);
        this.k = R.diff(this.L);
    }

    public double dt(int t) {
        return this.k[t];
    }

    public double dB(int t) {
        return this.E[t];
    }

    public int size() {
        return this.E.length;
    }

    public double[] T() {
        return Arrays.copyOf(this.L, this.L.length);
    }

    public double T(int t) {
        return this.L[t];
    }

    public double[] dBt() {
        return Arrays.copyOf(this.E, this.E.length);
    }

    public double[] dt() {
        return Arrays.copyOf(this.k, this.k.length);
    }

    public double B(int t) {
        return this.F[t];
    }
}

