/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.timepoints;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.stochasticprocess.timepoints.TimeGrid;

public class EvenlySpacedGrid
implements TimeGrid {
    public final int N;
    public final double T0;
    private final double E;
    public final double T;

    public EvenlySpacedGrid(double T0, double T2, int N) {
        SuanShuUtils.assertArgument(T0 < T2, "T0 < T", new Object[0]);
        SuanShuUtils.assertArgument(N > 1, "N < 1", new Object[0]);
        this.N = N;
        this.T0 = T0;
        this.T = T2;
        this.E = (T2 - T0) / (double)N;
    }

    @Override
    public double T() {
        return this.T;
    }

    @Override
    public double t(int i2) {
        return this.T0 + (double)(i2 - 1) * this.E;
    }

    @Override
    public int size() {
        return this.N + 1;
    }
}

