/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.ols;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.stats.regression.linear.LMProblem;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class Residuals
extends com.numericalmethod.suanshu.stats.regression.linear.Residuals {
    public final double AR2;
    public final ImmutableVector leverage;
    public final double f;
    private final int L;
    public final double RSS;
    public final double TSS;
    public final double stderr;
    public final ImmutableMatrix hHat;
    public final double R2;
    public final ImmutableVector wResiduals;
    public final ImmutableVector wFitted;
    private final int E;

    public Residuals(LMProblem a2, Vector a3) {
        super(a2, a2.A.multiply(a3));
        Residuals a4;
        a4.L = a2.nObs();
        a4.E = a2.nFactors();
        if (a2.weights != null) {
            a4.wFitted = new ImmutableVector(a2.wA.multiply(a3));
            a4.wResiduals = new ImmutableVector(a2.wy.minus(a4.wFitted));
        } else {
            a4.wFitted = a4.fitted;
            a4.wResiduals = a4.residuals;
        }
        a4.RSS = Math.pow(a4.wResiduals.norm(), 2.0);
        Vector a5 = a2.weights != null ? a2.weights : new DenseVector(a4.L, 1.0);
        double a6 = DoubleArrayMath.sum(a2.y.multiply(a5).toArray());
        Vector a7 = a2.y.minus((a6 /= DoubleArrayMath.sum(a5.toArray())) * (double)(a2.addIntercept ? 1 : 0));
        a4.TSS = DoubleArrayMath.sum(a7.multiply(a7).multiply(a5).toArray());
        a4.R2 = 1.0 - a4.RSS / a4.TSS;
        a4.AR2 = 1.0 - (double)(a4.L - (a2.addIntercept ? 1 : 0)) / (double)(a4.L - a4.E) * (1.0 - a4.R2);
        a4.stderr = Math.sqrt(a4.RSS / (double)(a4.L - a4.E));
        a4.f = (a4.TSS - a4.RSS) / (double)(a4.E - (a2.addIntercept ? 1 : 0)) / (a4.RSS / (double)(a4.L - a4.E));
        a4.hHat = new ImmutableMatrix(a2.wA.multiply(a2.invOfwAtwA()).multiply(a2.wA.t()));
        a4.leverage = new ImmutableVector(CreateVector.diagonal(a4.hHat));
    }

    public ImmutableVector studentized() {
        int a2;
        ImmutableVector a3 = this.standardized();
        double[] a4 = new double[this.L];
        int n = a2 = 0;
        while (n < this.L) {
            a4[a2] = a3.get(a2 + 1) * Math.sqrt((double)(this.L - this.E - 1) / ((double)(this.L - this.E) - a3.get(a2 + 1) * a3.get(a2 + 1)));
            n = ++a2;
        }
        ImmutableVector immutableVector = new ImmutableVector(new DenseVector(a4));
        return immutableVector;
    }

    public ImmutableVector standardized() {
        Vector a2 = this.leverage.minus(1.0).scaled(-1.0).pow(0.5);
        Vector a3 = this.wResiduals.divide(a2);
        a3 = a3.scaled(Math.sqrt(1.0 / (this.RSS / (double)(this.L - this.E))));
        return new ImmutableVector(a3);
    }
}

