/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.quasi;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.stats.regression.linear.glm.Fitting;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GLMProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.quasi.QuasiGlmProblem;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class NewtonRaphson
implements Fitting {
    public final double threshold;
    private Run E;
    public final int maxIterations;

    @Override
    public ImmutableVector betaHat() {
        return new ImmutableVector(this.E.E);
    }

    @Override
    public double logLikelihood() {
        return this.E.G;
    }

    public ImmutableMatrix D() {
        return new ImmutableMatrix(this.E.L);
    }

    public ImmutableMatrix DVInv() {
        return new ImmutableMatrix(this.E.k);
    }

    public NewtonRaphson(double a2, int a3) {
        NewtonRaphson a4;
        a4.threshold = a2;
        a4.maxIterations = a3;
    }

    @Override
    public ImmutableVector weights() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ImmutableVector mu() {
        return new ImmutableVector(this.E.i);
    }

    @Override
    public void fit(GLMProblem problem, Vector beta0Initial) {
        if (!(problem instanceof QuasiGlmProblem)) {
            throw new RuntimeException("the problem is not setup for quasi GLM");
        }
        this.E = new Run((QuasiGlmProblem)problem, beta0Initial, null);
    }

    public static class 1 {
    }

    private class Run {
        private Vector i;
        private double G = Double.POSITIVE_INFINITY;
        private final QuasiGlmProblem F;
        private Matrix k;
        private Matrix L;
        private Vector E;

        private Run(QuasiGlmProblem a2, Vector a3) {
            Run a4;
            a4.F = a2;
            a4.E = a3;
            a4.b();
        }

        public /* synthetic */ Run(QuasiGlmProblem a3, Vector a4, 1 a5) {
            a6(a3, a4);
            Run a6;
        }

        private void b() {
            Run a2;
            int a3 = a2.F.nObs();
            int a4 = a2.E.size();
            Family a5 = a2.F.quasiFamily.toFamily();
            a2.i = new DenseVector(a3);
            a2.L = new DenseMatrix(a3, a4);
            Vector a6 = new DenseVector(a4);
            boolean a7 = false;
            boolean bl = a7;
            for (int a8 = 0; !bl && a8 < a2.NewtonRaphson.this.maxIterations; ++a8) {
                int a9;
                int a10;
                int a11;
                Vector a12 = a2.F.A.multiply(a2.E);
                int n = a11 = 1;
                while (n <= a3) {
                    double a13 = a5.link().inverse(a12.get(a11));
                    a2.i.set(a11, a13);
                    int n2 = a10 = 1;
                    while (n2 <= a4) {
                        a2.L.set(a11, a10, a2.F.A.get(a11, a10) / a5.link().derivative(a13));
                        n2 = ++a10;
                    }
                    n = ++a11;
                }
                DiagonalMatrix a22 = new DiagonalMatrix(a3);
                int n3 = a9 = 1;
                while (n3 <= a3) {
                    a22.set(a9, a9, 1.0 / a5.variance(a2.i.get(a9)));
                    n3 = ++a9;
                }
                a2.k = a2.L.t().multiply(a22);
                ImmutableVector a32 = new ImmutableVector(a2.F.y.minus(a2.i));
                Vector a14 = new Inverse(a2.k.multiply(a2.L)).multiply(a2.k).multiply(a32);
                a6 = a2.E.add(a14);
                double a15 = 0.0;
                int n4 = a10 = 1;
                while (n4 <= a3) {
                    a15 += a2.F.quasiFamily.quasiLikelihood(a2.i.get(a10), a2.F.y.get(a10));
                    n4 = ++a10;
                }
                a7 = a2.E != null ? a6.minus(a2.E).norm() < a2.NewtonRaphson.this.threshold : false;
                a2.G = a15;
                a2.E = a6;
                bl = a7 |= Math.abs(a15 - a2.G) < a2.NewtonRaphson.this.threshold;
            }
        }
    }
}

