/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Log;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Poisson
extends Family {
    public Poisson() {
        this(new Log());
    }

    public Poisson(LinkFunction link) {
        super(link);
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return 1.0;
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double preLogLike, double deviance, int nFactors) {
        int a2;
        int a3 = y.size();
        double a4 = preLogLike;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += -Math.log(FunctionOps.factorial((int)y.get(a2)));
            n = ++a2;
        }
        return 2.0 * ((double)nFactors - a4);
    }

    @Override
    public double deviance(double y, double mu) {
        return 2.0 * (y * Math.log(y == 0.0 ? 1.0 : Math.abs(y / mu)) - y + mu);
    }

    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2;
        int a3 = y.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y.get(a2) - mu.get(a2), 2.0) / this.variance(mu.get(a2));
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    @Override
    public double cumulant(double theta) {
        return Math.exp(theta);
    }

    @Override
    public double variance(double mu) {
        return mu;
    }

    @Override
    public double theta(double mu) {
        return Math.log(mu);
    }
}

