/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Logit;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Binomial
extends Family {
    private final int E = 1;

    @Override
    public double variance(double mu) {
        return mu * (1.0 - mu);
    }

    private double b(double a2, double a3) {
        return a2 == 0.0 ? 0.0 : a2 * Math.log(Math.abs(a2 / a3));
    }

    @Override
    public double cumulant(double theta) {
        return Math.log(1.0 + Math.exp(theta));
    }

    public Binomial(LinkFunction link) {
        super(link);
    }

    @Override
    public double overdispersion(Vector y, Vector mu, int nFactors) {
        int a2;
        int a3 = y.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y.get(a2) - mu.get(a2), 2.0) / this.variance(mu.get(a2));
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    @Override
    public double dispersion(Vector y, Vector mu, int nFactors) {
        return 1.0;
    }

    @Override
    public double AIC(Vector y, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        double a2 = prelogLike;
        return 2.0 * ((double)nFactors - a2);
    }

    @Override
    public double deviance(double y, double mu) {
        return 2.0 * (this.b(y, mu) + this.b(1.0 - y, 1.0 - mu));
    }

    public Binomial() {
        this(new Logit());
    }

    @Override
    public double theta(double mu) {
        return Math.log(Math.abs(mu / (1.0 - mu)));
    }
}

