/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class LMProblem {
    public final ImmutableMatrix A;
    public final ImmutableMatrix wA;
    public final ImmutableVector weights;
    public final ImmutableVector y;
    public final boolean addIntercept;
    private volatile Matrix E = null;
    public final ImmutableVector wy;

    public int nExogenousFactors() {
        return this.A.nCols() - (this.addIntercept ? 1 : 0);
    }

    public LMProblem(Vector y, Matrix X, boolean addIntercept, Vector weights) {
        Matrix matrix;
        this.y = !(y instanceof ImmutableVector) ? new ImmutableVector(y) : (ImmutableVector)y;
        this.addIntercept = addIntercept;
        if (!addIntercept) {
            matrix = X;
        } else {
            Matrix[] matrixArray = new Matrix[2];
            matrixArray[0] = X;
            matrixArray[1] = new DenseMatrix(R.rep(1.0, X.nRows()), X.nRows(), 1);
            matrix = CreateMatrix.cbind(matrixArray);
        }
        this.A = new ImmutableMatrix(matrix);
        ImmutableVector immutableVector = weights != null ? (!(weights instanceof ImmutableVector) ? new ImmutableVector(weights) : (ImmutableVector)weights) : (this.weights = null);
        if (weights != null) {
            Vector a2 = weights.pow(0.5);
            DiagonalMatrix a3 = new DiagonalMatrix(a2.toArray());
            this.wA = new ImmutableMatrix(a3.multiply(this.A));
            this.wy = new ImmutableVector(y.multiply(a2));
        } else {
            this.wA = this.A;
            this.wy = this.y;
        }
        this.checkInputs();
    }

    public LMProblem(LMProblem that) {
        this.y = new ImmutableVector(that.y);
        this.A = new ImmutableMatrix(that.A);
        this.wy = new ImmutableVector(that.wy);
        this.wA = new ImmutableMatrix(that.wA);
        this.addIntercept = that.addIntercept;
        this.weights = that.weights == null ? null : new ImmutableVector(that.weights);
    }

    public Matrix X() {
        return !this.addIntercept ? this.A : CreateMatrix.subMatrix(this.A, 1, this.A.nRows(), 1, this.A.nCols() - 1);
    }

    public void checkInputs() {
        SuanShuUtils.assertArgument(this.y.size() == this.A.nRows(), "y and A do not have the same number of rows", new Object[0]);
        if (this.weights != null) {
            int a2;
            SuanShuUtils.assertArgument(this.weights.size() == this.y.size(), "weights and y do not have the same number of rows", new Object[0]);
            int n = a2 = 1;
            while (n <= this.weights.size()) {
                SuanShuUtils.assertArgument(this.weights.get(a2) >= 0.0, "all weights must be non negative", new Object[0]);
                n = ++a2;
            }
        }
    }

    public int nFactors() {
        return this.A.nCols();
    }

    public Matrix invOfwAtwA() {
        if (this.E == null) {
            this.E = new Inverse(this.wA.t().multiply(this.wA));
        }
        return this.E;
    }

    public int nObs() {
        return this.A.nRows();
    }

    public LMProblem(Vector y, Matrix X, Vector weights) {
        this(y, X, true, weights);
    }

    public LMProblem(Vector y, Matrix X) {
        this(y, X, true, null);
    }

    public LMProblem(Vector y, Matrix X, boolean addIntercept) {
        this(y, X, addIntercept, null);
    }
}

