/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.uniform.linear;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.linear.Lehmer;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.linear.LinearCongruentialGenerator;

public class MRG
implements LinearCongruentialGenerator {
    private Lehmer[] k;
    public final long m;
    private boolean[] L;
    private long[] E = null;

    @Override
    public long nextLong() {
        int a2;
        SuanShuUtils.assertOrThrow(this.E != null ? null : new RuntimeException("the generator has not been seeded"));
        long a3 = 0L;
        int n = a2 = this.k.length - 1;
        while (n >= 0) {
            if (this.k[a2] != null) {
                long l = a3 = this.L[a2] ? a3 + this.k[a2].nextLong() : a3 - this.k[a2].nextLong();
                while (l < 0L) {
                    l = a3 + this.m;
                }
                if (a3 > this.m) {
                    a3 %= this.m;
                }
            }
            n = --a2;
        }
        int n2 = a2 = this.k.length - 1;
        while (n2 >= 0) {
            long l = a2 == 0 ? a3 : (this.E[a2] = this.E[a2 - 1]);
            if (this.k[a2] != null) {
                long[] lArray = new long[1];
                lArray[0] = this.E[a2];
                this.k[a2].seed(lArray);
            }
            n2 = --a2;
        }
        return a3;
    }

    public MRG(long m2, long ... a2) {
        int a3;
        this.m = m2;
        this.k = new Lehmer[a2.length];
        this.L = new boolean[a2.length];
        int n = a3 = 0;
        while (n < a2.length) {
            if (a2[a3] != 0L) {
                this.k[a3] = new Lehmer(Math.abs(a2[a3]), m2, 0L);
                this.L[a3] = a2[a3] > 0L;
            }
            n = ++a3;
        }
    }

    @Override
    public int order() {
        return this.k.length;
    }

    @Override
    public void seed(long ... x) {
        int a2;
        SuanShuUtils.assertArgument(x.length == this.k.length, "unmatched number of seeds", new Object[0]);
        this.E = new long[x.length];
        int n = a2 = 0;
        while (n < this.k.length) {
            this.E[a2] = x[a2];
            if (this.k[a2] != null) {
                long[] lArray = new long[1];
                lArray[0] = x[a2];
                this.k[a2].seed(lArray);
            }
            n = ++a2;
        }
    }

    @Override
    public double nextDouble() {
        return (double)this.nextLong() / (double)this.m;
    }

    @Override
    public long modulus() {
        return this.m;
    }
}

