/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.uniform.linear;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.linear.LinearCongruentialGenerator;
import java.util.Arrays;

public class CombinedLinearCongruentialGenerator
implements LinearCongruentialGenerator {
    private LinearCongruentialGenerator[] L;
    private final long E;

    public CombinedLinearCongruentialGenerator(LinearCongruentialGenerator[] rng) {
        int a2;
        SuanShuUtils.assertArgument(rng.length > 0, "no random generator was found", new Object[0]);
        this.L = rng;
        long a3 = 0L;
        int n = a2 = 0;
        while (n < rng.length) {
            if (rng[a2].modulus() > a3) {
                a3 = rng[a2].modulus();
            }
            n = ++a2;
        }
        this.E = a3;
    }

    @Override
    public int order() {
        int a2;
        int a3 = 0;
        LinearCongruentialGenerator[] a4 = this.L;
        int a5 = this.L.length;
        int n = a2 = 0;
        while (n < a5) {
            LinearCongruentialGenerator a6 = a4[a2];
            a3 += a6.order();
            n = ++a2;
        }
        return a3;
    }

    @Override
    public long nextLong() {
        int a2;
        long a3 = 0L;
        int n = a2 = 0;
        while (n < this.L.length) {
            long a4 = this.L[a2].nextLong();
            a3 = a2 % 2 == 1 ? (a3 -= a4) : (a3 += a4);
            long l = a3;
            while (l < 0L) {
                l = a3 + this.E;
            }
            if (a3 > this.E) {
                a3 %= this.E;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public void seed(long ... seeds) {
        int a2 = 0;
        int a3 = 0;
        int n = a2;
        while (n < this.L.length) {
            long[] a4 = Arrays.copyOfRange(seeds, a3, a3 + this.L[a2].order());
            this.L[a2].seed(a4);
            a3 += this.L[a2].order();
            n = ++a2;
        }
    }

    @Override
    public double nextDouble() {
        double a2;
        long a3 = this.nextLong();
        if (a3 > 0L) {
            a2 = (double)a3 / (double)(this.E - 1L);
        } else if (a3 == 0L) {
            a2 = (double)(this.E - 1L) / (double)this.E;
        } else {
            throw new RuntimeException("-ve. x");
        }
        return a2;
    }

    @Override
    public long modulus() {
        return this.E;
    }
}

