/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.uniform;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.MersenneTwister;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.linear.LEcuyer;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.linear.Lehmer;

public class UniformRng
implements RandomLongGenerator {
    public final Method method;
    private RandomLongGenerator E;

    @Override
    public double nextDouble() {
        return this.E.nextDouble();
    }

    public UniformRng(Method method) {
        this.method = method;
        switch (this.method) {
            case LEHMER: {
                this.E = new Lehmer();
                break;
            }
            case LECUYER: {
                do {
                } while (false);
                this.E = new LEcuyer();
                break;
            }
            default: {
                this.E = new MersenneTwister();
            }
        }
    }

    @Override
    public long nextLong() {
        return this.E.nextLong();
    }

    public UniformRng() {
        this(Method.MERSENNE_TWISTER);
    }

    static {
        Package.getInstance("BASIC").isValidated();
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LEHMER;
        public static final /* enum */ Method MERSENNE_TWISTER;
        public static final /* enum */ Method LECUYER;
        private static final /* synthetic */ Method[] E;

        public static Method[] values() {
            return (Method[])E.clone();
        }

        static {
            MERSENNE_TWISTER = new Method();
            LEHMER = new Method();
            LECUYER = new Method();
            Method[] methodArray = new Method[3];
            methodArray[0] = MERSENNE_TWISTER;
            methodArray[1] = LEHMER;
            methodArray[2] = LECUYER;
            E = methodArray;
        }

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }
    }
}

