/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.gamma;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.gamma.RandomGammaGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class XiTanLiu2010b
implements RandomGammaGenerator {
    private final double M;
    private final double i;
    private final double G;
    private final double F;
    private static final double k = Math.exp(1.0);
    private final double L;
    private final RandomLongGenerator E;

    @Override
    public double nextDouble() {
        double a2;
        double a3;
        double a4;
        double a5;
        do {
            a5 = this.E.nextDouble();
            a4 = this.E.nextDouble();
            a4 *= this.L;
            a4 += this.G;
            a2 = (a4 /= (a5 *= this.i)) / this.F;
            a3 = Math.exp(a2);
        } while (!(2.0 * Math.log(a5) <= a4 - a3));
        if (this.F >= 0.01) {
            return a3;
        }
        return a2;
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }

    public XiTanLiu2010b(double k) {
        this(k, new UniformRng());
    }

    public XiTanLiu2010b(double k, RandomLongGenerator uniform) {
        SuanShuUtils.assertArgument(k > 0.0, "the shape parameter must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(k <= 1.0, "the shape parameter must be <= 1", new Object[0]);
        this.F = k;
        this.E = uniform;
        this.i = Math.pow(k / XiTanLiu2010b.k, k / 2.0);
        this.G = -2.0 / XiTanLiu2010b.k;
        this.M = 2.0 * k / XiTanLiu2010b.k / (XiTanLiu2010b.k - k);
        this.L = this.M - this.G;
    }
}

