/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.gamma;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.gamma.RandomGammaGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class XiTanLiu2010a
implements RandomGammaGenerator {
    private final double i;
    private final double G;
    private final double F;
    private final RandomLongGenerator k;
    private final double L;
    private final double E;

    public XiTanLiu2010a(double k, RandomLongGenerator uniform) {
        SuanShuUtils.assertArgument(k > 0.0, "the shape parameter must be > 0", new Object[0]);
        this.i = k;
        this.k = uniform;
        this.E = Math.log(k);
        this.G = Math.sqrt(k);
        double a2 = this.m(this.E);
        double a3 = this.b(this.E);
        this.L = Math.exp(a2);
        this.F = -Math.exp(a3);
    }

    @Override
    public void seed(long ... seeds) {
        this.k.seed(seeds);
    }

    private double m(double a2) {
        if (a2 > 1.448931546292675) {
            return -0.153426409720027;
        }
        if (-3.333189906461192 <= a2 && a2 < 1.448931546292675) {
            return 0.124651796958072 * a2 - 0.334038330634647;
        }
        return 0.306252995504409 * a2 + 0.27127295136126;
    }

    @Override
    public double nextDouble() {
        double a2;
        double a3;
        double a4;
        double a5;
        do {
            a5 = this.k.nextDouble();
            double a6 = this.k.nextDouble();
            a6 *= this.L - this.F;
            a4 = (a6 += this.F) / a5;
            a2 = a4 / this.G + this.E;
            a3 = Math.exp(a2);
        } while (!(2.0 * Math.log(a5) <= this.i + this.G * a4 - a3));
        if (this.i >= 0.01) {
            return a3;
        }
        return a2;
    }

    private double b(double a2) {
        XiTanLiu2010a a3;
        if (a2 > 1.764216686288215) {
            return -0.048065894062201;
        }
        if (0.521223243207446 <= a2 && a2 < 1.764216686288215) {
            return -0.084763530978316 * a2 + 0.101475344169199;
        }
        if (0.209314923020777 <= a2 && a2 < 0.521223243207446) {
            return -0.135460234584798 * a2 + 0.127899644442896;
        }
        return -0.306852819440055 - a2 / 2.0 + a3.i / 2.0;
    }

    public XiTanLiu2010a(double k) {
        this(k, new UniformRng());
    }
}

