/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.gamma;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.gamma.RandomGammaGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.normal.RandomStandardNormalNumberGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.normal.StandardNormalRng;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class MarsagliaTsang2000
implements RandomGammaGenerator {
    private final double F;
    private final RandomStandardNormalNumberGenerator k;
    private final Generate L;
    private final RandomLongGenerator E;

    public MarsagliaTsang2000(double k, double theta) {
        this(k, theta, new StandardNormalRng(), new UniformRng());
    }

    public MarsagliaTsang2000(double k, double theta, RandomStandardNormalNumberGenerator normal, RandomLongGenerator uniform) {
        SuanShuUtils.assertArgument(k > 0.0, "the shape parameter must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(theta > 0.0, "the scale parameter must be > 0", new Object[0]);
        this.F = theta;
        this.k = normal;
        this.E = uniform;
        this.L = k >= 1.0 ? new Kg1(k, null) : new Kl1(k, null);
    }

    public MarsagliaTsang2000() {
        this(1.0, 1.0);
    }

    @Override
    public void seed(long ... seeds) {
        this.k.seed(seeds);
        this.E.seed(seeds);
    }

    @Override
    public double nextDouble() {
        return this.L.nextDouble();
    }

    public static class 1 {
    }

    private class Kl1
    implements Generate {
        private final Kg1 L;
        private final double E;

        @Override
        public double nextDouble() {
            double a2 = this.L.nextDouble();
            double a3 = Math.pow(MarsagliaTsang2000.this.E.nextDouble(), this.E);
            return a3 *= a2;
        }

        private Kl1(double a2) {
            Kl1 a3;
            a3.L = new Kg1(a2 + 1.0, null);
            a3.E = 1.0 / a2;
        }

        public /* synthetic */ Kl1(double a3, 1 a4) {
            a5(a3);
            Kl1 a5;
        }
    }

    private class Kg1
    implements Generate {
        private final double L;
        private final double E;

        @Override
        public double nextDouble() {
            double a2;
            while (true) {
                double a3;
                double a4;
                double a5;
                if ((a2 = 1.0 + this.L * (a5 = MarsagliaTsang2000.this.k.nextDouble())) <= 0.0) {
                    continue;
                }
                a2 = a2 * a2 * a2;
                double a6 = MarsagliaTsang2000.this.E.nextDouble();
                if (a6 < 1.0 - 0.0331 * (a4 = (a3 = a5 * a5) * a3)) {
                    return this.E * a2 * MarsagliaTsang2000.this.F;
                }
                if (Math.log(a6) < 0.5 * a3 + this.E * (1.0 - a2 + Math.log(a2))) break;
            }
            return this.E * a2 * MarsagliaTsang2000.this.F;
        }

        private Kg1(double a2) {
            Kg1 a3;
            a3.E = a2 - 0.3333333333333333;
            a3.L = 1.0 / Math.sqrt(9.0 * a3.E);
        }

        public /* synthetic */ Kg1(double a3, 1 a4) {
            a5(a3);
            Kg1 a5;
        }
    }

    private static interface Generate {
        public double nextDouble();
    }
}

