/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.univariate.beta;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.beta.RandomBetaGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class Cheng1978
implements RandomBetaGenerator {
    private double D;
    private double I;
    private double l;
    private double H;
    private static final double f = Math.log(Double.MAX_VALUE);
    private double M;
    private double i;
    private double G;
    private double F;
    private double k;
    private double L;
    private final RandomLongGenerator E;

    private double b(double a2, double a3) {
        double a4;
        if (a2 <= f) {
            a4 = a3 * Math.exp(a2);
            if (Double.isInfinite(a4)) {
                a4 = Double.MAX_VALUE;
            }
        } else {
            a4 = Double.MAX_VALUE;
        }
        return a4;
    }

    public Cheng1978(double aa, double bb, RandomLongGenerator uniform) {
        SuanShuUtils.assertArgument(aa > 0.0, "alpha must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(bb > 0.0, "beta must be > 0", new Object[0]);
        this.k = aa;
        this.F = bb;
        this.E = uniform;
        this.i = Math.min(aa, bb);
        this.H = Math.max(aa, bb);
        this.M = this.i + this.H;
        if (this.i <= 1.0) {
            this.l = 1.0 / this.i;
            this.L = 1.0 + this.H - this.i;
            this.G = this.L * (0.0138889 + 0.0416667 * this.i) / (this.H * this.l - 0.777778);
            this.I = 0.25 + (0.5 + 0.25 / this.L) * this.i;
        } else {
            this.l = Math.sqrt((this.M - 2.0) / (2.0 * this.i * this.H - this.M));
            this.D = this.i + 1.0 / this.l;
        }
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }

    @Override
    public double nextDouble() {
        if (this.i <= 1.0) {
            return this.b();
        }
        return this.m();
    }

    private double m() {
        double a2;
        Cheng1978 a3;
        double a4;
        double a5;
        double a6;
        double a7;
        double d2;
        do {
            double a8 = a3.E.nextDouble();
            double a9 = a3.E.nextDouble();
            double a10 = a3.b(a8);
            a2 = a3.b(a10, a3.i);
            a7 = a8 * a8 * a9;
            a4 = a3.D * a10 - 1.3862944;
            a6 = a3.i + a4 - a2;
        } while (!(d2 + 2.609438 >= 5.0 * a7) && !(a6 > (a5 = Math.log(a7))) && a4 + a3.M * Math.log(a3.M / (a3.H + a2)) < a5);
        return a3.k != a3.i ? a3.H / (a3.H + a2) : a2 / (a3.H + a2);
    }

    public Cheng1978(double aa, double bb) {
        this(aa, bb, new UniformRng());
    }

    private double b(double a2) {
        Cheng1978 a3;
        return a3.l * Math.log(a2 / (1.0 - a2));
    }

    private double b() {
        double a2;
        double a3;
        double a4;
        double a5;
        Cheng1978 a6;
        block0: do {
            Cheng1978 cheng1978 = a6;
            block1: while (true) {
                RandomLongGenerator randomLongGenerator = cheng1978.E;
                while (true) {
                    double d2;
                    a3 = randomLongGenerator.nextDouble();
                    double a7 = a6.E.nextDouble();
                    if (a3 < 0.5) {
                        double a8 = a3 * a7;
                        a2 = a3 * a8;
                        if (!(0.25 * a7 + a2 - a8 >= a6.G)) continue block0;
                        cheng1978 = a6;
                        continue block1;
                    }
                    a2 = a3 * a3 * a7;
                    if (d2 <= 0.25) {
                        a4 = a6.b(a3);
                        a5 = a6.b(a4, a6.H);
                        break block0;
                    }
                    if (!(a2 >= a6.I)) continue block0;
                    randomLongGenerator = a6.E;
                }
                break;
            }
        } while (!(a6.M * (Math.log(a6.M / (a6.i + (a5 = a6.b(a4 = a6.b(a3), a6.H)))) + a4) - 1.3862944 >= Math.log(a2)));
        return a6.k == a6.i ? a6.i / (a6.i + a5) : a5 / (a6.i + a5);
    }
}

