/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.multivariate;

import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.multivariate.RandomVectorGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;

public class MultinomialRvg
implements RandomVectorGenerator {
    private final double[] k;
    private final int L;
    private final RandomLongGenerator E;

    public MultinomialRvg(int size, double[] prob, RandomLongGenerator rng) {
        int a2;
        this.L = size;
        this.k = new double[prob.length];
        this.k[0] = prob[0];
        int n = a2 = 1;
        while (n < prob.length) {
            this.k[a2] = this.k[a2 - 1] + prob[a2];
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (true) {
            if (n2 >= prob.length - 1) break;
            int n3 = a2++;
            this.k[n3] = this.k[n3] / this.k[prob.length - 1];
            n2 = a2;
        }
        this.k[prob.length - 1] = 1.0;
        this.E = rng;
    }

    public MultinomialRvg(int size, double[] prob) {
        this(size, prob, new UniformRng());
    }

    @Override
    public double[] nextVector() {
        int a2;
        double[] a3 = new double[this.k.length];
        double[] a4 = new IID(this.E, this.L).nextVector();
        int n = a2 = 0;
        while (n < a4.length) {
            int a5;
            double a6 = a4[a2];
            int n2 = a5 = 0;
            while (n2 < this.k.length) {
                if (a6 <= this.k[a5]) {
                    int n3 = a5;
                    a3[n3] = a3[n3] + 1.0;
                    break;
                }
                n2 = ++a5;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public void seed(long ... seeds) {
        this.E.seed(seeds);
    }
}

