/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.hmm;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.hmm.HmmInnovation;
import com.numericalmethod.suanshu.stats.markovchain.SimpleMC;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Arrays;

public class HiddenMarkovModel
extends SimpleMC {
    private final RandomNumberGenerator[] E;

    public HiddenMarkovModel(Vector PI, Matrix A, RandomNumberGenerator[] B) {
        super(PI, A);
        SuanShuUtils.assertArgument(B.length == A.nRows(), "the number of rows of B should be the same as the number of states", new Object[0]);
        this.E = Arrays.copyOf(B, A.nRows());
    }

    @Override
    public void seed(long ... seeds) {
        int a2;
        int n = a2 = 0;
        while (n < this.E.length) {
            this.E[a2].seed(seeds);
            n = ++a2;
        }
        super.seed(seeds);
    }

    public HiddenMarkovModel(HiddenMarkovModel that) {
        this(that.PI(), that.A(), that.E);
    }

    public HiddenMarkovModel(Matrix A, RandomNumberGenerator[] B) {
        this(HiddenMarkovModel.getStationaryProbabilities(A), A, B);
    }

    public HmmInnovation next() {
        int a2 = this.nextState();
        double a3 = this.E[a2 - 1].nextDouble();
        return new HmmInnovation(a2, a3);
    }

    @Override
    public double nextDouble() {
        return this.E[this.nextState() - 1].nextDouble();
    }
}

