/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.univariate.normal.NormalRng;

public class StateEquation {
    private final UnivariateRealFunction F;
    private final NormalRng k;
    private final UnivariateRealFunction L;
    private final UnivariateRealFunction E;

    public double H(int t) {
        return this.F.evaluate((double)t);
    }

    public double G(int t) {
        return this.L.evaluate((double)t);
    }

    public double xt_mean(int t, double xt_1) {
        return this.xt_mean(t, xt_1, 0.0);
    }

    public StateEquation(double G, double W) {
        this(G, 0.0, W, new NormalRng(0.0, 1.0));
    }

    public StateEquation(final double G, final double H, final double W, NormalRng rnorm) {
        this(new UnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double x) {
                return G;
            }
        }, new UnivariateRealFunction(){
            {
                3 a2;
            }

            @Override
            public double evaluate(double x) {
                return H;
            }
        }, new UnivariateRealFunction(){
            {
                4 a2;
            }

            @Override
            public double evaluate(double x) {
                return W;
            }
        }, rnorm);
    }

    public StateEquation(UnivariateRealFunction G, UnivariateRealFunction W) {
        this(G, new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return 0.0;
            }
        }, W);
    }

    public StateEquation(UnivariateRealFunction G, UnivariateRealFunction H, UnivariateRealFunction W, NormalRng rnorm) {
        SuanShuUtils.assertArgument(G.dimensionOfDomain() == H.dimensionOfDomain() && H.dimensionOfDomain() == W.dimensionOfDomain(), "the domain dimensions of F and V and W must match", new Object[0]);
        this.L = G;
        this.F = H;
        this.E = W;
        this.k = rnorm;
    }

    public StateEquation(UnivariateRealFunction G, UnivariateRealFunction H, UnivariateRealFunction W) {
        this(G, H, W, new NormalRng(0.0, 1.0));
    }

    public double xt_mean(int t, double xt_1, double ut) {
        double a2 = this.L.evaluate((double)t) * xt_1;
        if (this.F != null) {
            double a3 = this.F.evaluate((double)t) * ut;
            a2 += a3;
        }
        return a2;
    }

    public double xt(int t, double xt_1, double ut) {
        double a2 = this.xt_mean(t, xt_1, ut);
        double a3 = this.k.nextDouble() * Math.sqrt(this.E.evaluate((double)t));
        return a2 += a3;
    }

    public StateEquation(StateEquation that) {
        this(that.L, that.F, that.E);
    }

    public double xt_var(int t, double var_tlag_tlag) {
        double a2 = this.G(t);
        double a3 = this.W(t);
        return a2 * var_tlag_tlag * a2 + a3;
    }

    public double xt(int t, double xt_1) {
        return this.xt(t, xt_1, 0.0);
    }

    public double W(int t) {
        return this.E.evaluate((double)t);
    }

    public int dimension() {
        return 1;
    }
}

