/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.stats.dlm.multivariate.DLM;
import com.numericalmethod.suanshu.stats.dlm.multivariate.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.multivariate.StateEquation;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class LinearKalmanFilter {
    private DenseMatrix f;
    private Matrix[] M;
    private DenseMatrix i;
    private Matrix[] G;
    private Matrix[] F;
    private final DLM k;
    private DenseMatrix L;
    private Matrix[] E;

    public void filtering(MultiVariateTimeSeries Yt, MultiVariateTimeSeries Ut) {
        int a2;
        StateEquation a3 = this.k.getStateModel();
        ObservationEquation a4 = this.k.getObservationModel();
        int a5 = this.k.stateDimension();
        int a6 = this.k.obsDimension();
        int a7 = Yt.size();
        DenseMatrix a8 = new DenseMatrix(Yt.toMatrix());
        DenseMatrix a9 = Ut != null ? new DenseMatrix(Ut.toMatrix()) : null;
        this.f = new DenseMatrix(a7, a5);
        this.G = new DenseMatrix[a7];
        this.L = new DenseMatrix(a7, a6);
        this.M = new DenseMatrix[a7];
        this.F = new DenseMatrix[a7];
        this.i = new DenseMatrix(a7, a5);
        this.E = new DenseMatrix[a7];
        int n = a2 = 1;
        while (n <= a7) {
            ImmutableVector a10 = a2 > 1 ? this.i.getRow(a2 - 1) : this.k.m0();
            Vector a11 = a3.xt_mean(a2, a10, a9 != null ? a9.getRow(a2) : null);
            this.f.setRow(a2, a11);
            ImmutableMatrix a12 = a2 > 1 ? this.E[a2 - 2] : this.k.C0();
            Matrix a13 = a3.xt_var(a2, a12);
            this.G[a2 - 1] = a13;
            Vector a14 = a4.yt_mean(a2, a11);
            this.L.setRow(a2, a14);
            Matrix a15 = a4.yt_var(a2, a13);
            this.M[a2 - 1] = a15;
            Matrix a16 = a4.F(a2);
            this.F[a2 - 1] = new DenseMatrix(a13.multiply(a16.t()).multiply(new Inverse(a15)));
            Vector a17 = a8.getRow(a2).minus(a14);
            Vector a18 = a11.add(this.F[a2 - 1].multiply(a17));
            this.i.setRow(a2, a18);
            Matrix a19 = a13.minus(this.F[a2 - 1].multiply(a16).multiply(a13));
            this.E[a2 - 1] = a19;
            n = ++a2;
        }
    }

    public int dimension() {
        return this.i.nCols();
    }

    public Matrix getKalmanGain(int t) {
        return new ImmutableMatrix(this.F[t - 1]);
    }

    public Matrix getPredictedObservationVariance(int t) {
        return new ImmutableMatrix(this.M[t - 1]);
    }

    public Matrix getPredictedStateVariance(int t) {
        return new ImmutableMatrix(this.G[t - 1]);
    }

    public SimpleMultiVariateTimeSeries getPredictedObservations() {
        return new SimpleMultiVariateTimeSeries(this.L);
    }

    public SimpleMultiVariateTimeSeries getFittedStates() {
        return new SimpleMultiVariateTimeSeries(this.i);
    }

    public Vector getPredictedObservation(int t) {
        return this.L.getRow(t);
    }

    public Vector getFittedState(int t) {
        return this.i.getRow(t);
    }

    public Vector getPredictedState(int t) {
        return this.f.getRow(t);
    }

    public SimpleMultiVariateTimeSeries getPredictedStates() {
        return new SimpleMultiVariateTimeSeries(this.f);
    }

    public Matrix getFittedStateVariance(int t) {
        return new ImmutableMatrix(this.E[t - 1]);
    }

    public int size() {
        return this.i.nRows();
    }

    public LinearKalmanFilter(DLM model) {
        this.k = model;
    }

    public void filtering(MultiVariateTimeSeries Yt) {
        this.filtering(Yt, null);
    }
}

