/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.Gamma;
import com.numericalmethod.suanshu.analysis.sequence.Summation;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class WeibullDistribution
implements UnivariateDistribution {
    private static final Gamma E = new Gamma(Gamma.Method.LANCZOS_QUICK);
    public final double lambda;
    public final double k;

    @Override
    public double median() {
        return this.lambda * Math.pow(Math.log(2.0), 1.0 / this.k);
    }

    @Override
    public double mean() {
        return this.lambda * E.evaluate(1.0 + 1.0 / this.k);
    }

    @Override
    public double skew() {
        double a2 = this.mean();
        double a3 = Math.sqrt(this.variance());
        double a4 = E.evaluate(1.0 + 3.0 / this.k) * this.lambda * this.lambda * this.lambda;
        a4 -= 3.0 * a2 * a3 * a3;
        a4 -= a2 * a2 * a2;
        return a4 /= a3 * a3 * a3;
    }

    @Override
    public double moment(double x) {
        double a2 = 0.0;
        final double a3 = x;
        a2 = new Summation(new Summation.Term(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double n) {
                int a2;
                double a32 = E.evaluate(1.0 + n / WeibullDistribution.this.k);
                int n2 = a2 = 1;
                while ((long)n2 <= Math.round(n)) {
                    a32 *= a3 * WeibullDistribution.this.lambda / (double)a2;
                    n2 = ++a2;
                }
                return a32;
            }
        }).sumToInfinity(0.0, 1.0);
        return a2;
    }

    @Override
    public double variance() {
        double a2 = this.mean();
        return this.lambda * this.lambda * E.evaluate(1.0 + 2.0 / this.k) - a2 * a2;
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return 1.0 - Math.exp(-Math.pow(x / this.lambda, this.k));
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double a2 = this.k / this.lambda;
        a2 *= Math.pow(x / this.lambda, this.k - 1.0);
        return a2 *= Math.exp(-Math.pow(x / this.lambda, this.k));
    }

    public WeibullDistribution(double lambda, double k) {
        SuanShuUtils.assertArgument(lambda > 0.0, "lambda must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(k > 0.0, "k must be > 0", new Object[0]);
        this.lambda = lambda;
        this.k = k;
    }

    @Override
    public double kurtosis() {
        double a2 = this.mean();
        double a3 = Math.sqrt(this.variance());
        double a4 = this.skew();
        double a5 = E.evaluate(1.0 + 4.0 / this.k) * this.lambda * this.lambda * this.lambda * this.lambda;
        a5 -= 4.0 * a4 * a3 * a3 * a3 * a2;
        a5 -= 6.0 * a2 * a2 * a3 * a3;
        a5 -= a2 * a2 * a2 * a2;
        a5 /= a3 * a3 * a3 * a3;
        return a5 -= 3.0;
    }

    @Override
    public double entropy() {
        return 0.5772156649015329 * (1.0 - 1.0 / this.k) + Math.log(this.lambda / this.k) + 1.0;
    }

    @Override
    public double quantile(double u) {
        return this.lambda * Math.pow(-Math.log(1.0 - u), 1.0 / this.k);
    }
}

