/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class TDistribution
implements UnivariateDistribution {
    private static final LogGamma G;
    private final BetaRegularized F;
    private static final Digamma k;
    private static final LogBeta L;
    public final double v;
    private final BetaRegularizedInverse E;

    @Override
    public double median() {
        return 0.0;
    }

    public TDistribution(double v) {
        SuanShuUtils.assertArgument(v > 0.0, "only for v > 0", new Object[0]);
        this.v = v;
        this.F = new BetaRegularized(v / 2.0, v / 2.0);
        this.E = new BetaRegularizedInverse(v / 2.0, v / 2.0);
    }

    @Override
    public double entropy() {
        double a2 = (this.v + 1.0) / 2.0;
        a2 *= k.evaluate((1.0 + this.v) / 2.0) - k.evaluate(this.v / 2.0);
        return a2 += Math.log(Math.sqrt(this.v)) + L.evaluate(this.v / 2.0, 0.5);
    }

    static {
        L = new LogBeta();
        G = new LogGamma();
        k = new Digamma();
    }

    @Override
    public double variance() {
        SuanShuUtils.assertOrThrow(this.v >= 2.0 ? null : new UnsupportedOperationException("only for v >= 2"));
        if (this.v == 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.v / (this.v - 2.0);
    }

    @Override
    public double kurtosis() {
        SuanShuUtils.assertOrThrow(this.v > 4.0 ? null : new UnsupportedOperationException("only for v > 4"));
        return 6.0 / (this.v - 4.0);
    }

    @Override
    public double density(double x) {
        if (DoubleUtils.compare(x, 0.0) == 0) {
            return 0.0;
        }
        double a2 = G.evaluate((this.v + 1.0) / 2.0);
        a2 -= Math.log(Math.sqrt(this.v * Math.PI)) + G.evaluate(this.v / 2.0);
        a2 += -(this.v + 1.0) / 2.0 * Math.log(1.0 + x * x / this.v);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double quantile(double u) {
        double a2 = this.E.evaluate(u);
        double a3 = 0.25 / (a2 - 0.5) / (a2 - 0.5) / this.v - 1.0 / this.v;
        a3 = 1.0 / a3;
        a3 = Math.sqrt(a3);
        a3 = a2 - 0.5 > 0.0 ? a3 : -a3;
        return a3;
    }

    @Override
    public double skew() {
        SuanShuUtils.assertOrThrow(this.v > 3.0 ? null : new UnsupportedOperationException("only for v > 3"));
        return 0.0;
    }

    @Override
    public double mean() {
        SuanShuUtils.assertOrThrow(this.v > 1.0 ? null : new UnsupportedOperationException("only for v > 1"));
        return 0.0;
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("not defined.");
    }

    @Override
    public double cdf(double x) {
        double a2 = x;
        a2 /= 2.0 * Math.sqrt(x * x + this.v);
        return this.F.evaluate(a2 += 0.5);
    }
}

