/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.special.Erf;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class RayleighDistribution
implements UnivariateDistribution {
    public final double sigma;

    @Override
    public double variance() {
        return this.sigma * this.sigma * 0.8584073464102069 / 2.0;
    }

    @Override
    public double entropy() {
        return 1.0 + Math.log(this.sigma / Constant.ROOT_2) + 0.28860783245076643;
    }

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be positive";
        return x / this.sigma / this.sigma * Math.exp(-x * x / 2.0 / this.sigma / this.sigma);
    }

    @Override
    public double quantile(double u) {
        return this.sigma * Math.sqrt(-2.0 * Math.log(1.0 - u));
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return 1.0 - Math.exp(-x * x / 2.0 / this.sigma / this.sigma);
    }

    @Override
    public double skew() {
        return 2.0 * Constant.ROOT_PI * 0.14159265358979312 / Math.pow(0.8584073464102069, 1.5);
    }

    @Override
    public double mean() {
        return this.sigma * Math.sqrt(1.5707963267948966);
    }

    @Override
    public double kurtosis() {
        return 0.18059727961888683 / Math.pow(0.8584073464102069, 2.0);
    }

    public RayleighDistribution(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be > 0");
        }
        this.sigma = sigma;
    }

    @Override
    public double median() {
        return this.sigma * Math.sqrt(Math.log(4.0));
    }

    @Override
    public double moment(double t) {
        Erf a2 = new Erf();
        return 1.0 + this.sigma * t * Math.exp(this.sigma * this.sigma * t * t / 2.0) * Math.sqrt(1.5707963267948966) * (a2.evaluate(this.sigma * t / Constant.ROOT_2) + 1.0);
    }
}

