/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class LogNormalDistribution
implements UnivariateDistribution {
    public final double sigma;
    public final double mu;
    private final NormalDistribution E;

    @Override
    public double skew() {
        double a2 = Math.exp(this.sigma * this.sigma);
        double a3 = a2 + 2.0;
        return a3 *= Math.sqrt(a2 - 1.0);
    }

    public LogNormalDistribution(double mu, double sigma) {
        SuanShuUtils.assertArgument(sigma > 0.0, "standard deviation must be > 0", new Object[0]);
        this.mu = mu;
        this.sigma = sigma;
        this.E = new NormalDistribution(mu, sigma);
    }

    @Override
    public double moment(double s2) {
        double a2 = s2 * this.mu;
        a2 += 0.5 * s2 * s2 * this.sigma * this.sigma;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double variance() {
        double a2 = this.sigma * this.sigma;
        double a3 = Math.exp(a2) - 1.0;
        return a3 *= Math.exp(2.0 * this.mu + a2);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return this.E.cdf(Math.log(x));
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double a2 = this.E.density(Math.log(x));
        return a2 /= x;
    }

    @Override
    public double kurtosis() {
        double a2 = this.sigma * this.sigma;
        double a3 = Math.exp(4.0 * a2);
        a3 += 2.0 * Math.exp(3.0 * a2);
        a3 += 3.0 * Math.exp(2.0 * a2);
        return a3 -= 6.0;
    }

    @Override
    public double median() {
        return Math.exp(this.mu);
    }

    @Override
    public double mean() {
        double a2 = this.mu + this.sigma * this.sigma / 2.0;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double quantile(double u) {
        return Math.exp(this.E.quantile(u));
    }

    @Override
    public double entropy() {
        double a2 = 0.5;
        a2 = 0.5 + (0.5 * Math.log(Math.PI * 2 * this.sigma * this.sigma) + this.mu);
        return a2;
    }
}

