/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class FDistribution
implements UnivariateDistribution {
    public final double df2;
    private static final LogBeta k = new LogBeta();
    public final double df1;
    private final BetaRegularized L;
    private final BetaRegularizedInverse E;

    @Override
    public double density(double x) {
        SuanShuUtils.assertArgument(x >= 0.0, "x must be >= 0", new Object[0]);
        if (DoubleUtils.compare(x, 0.0) == 0) {
            if (this.df1 < 2.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.df1 == 2.0) {
                return 1.0;
            }
            return 0.0;
        }
        double a2 = this.df1 * Math.log(this.df1 * x);
        a2 += this.df2 * Math.log(this.df2);
        a2 -= (this.df1 + this.df2) * Math.log(this.df1 * x + this.df2);
        a2 /= 2.0;
        a2 -= Math.log(x);
        a2 -= k.evaluate(this.df1 / 2.0, this.df2 / 2.0);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double kurtosis() {
        SuanShuUtils.assertOrThrow(this.df2 > 8.0 ? null : new UnsupportedOperationException("only supported for df2 > 8"));
        double a2 = 5.0 * this.df2 * this.df2 * this.df1 - 22.0 * this.df1 * this.df1 + 5.0 * this.df2 * this.df1 * this.df1 - 16.0;
        double a3 = 20.0 * this.df2 - 8.0 * this.df2 * this.df2 + this.df2 * this.df2 * this.df2 + 44.0 * this.df1 - 32.0 * this.df1 * this.df2 + a2;
        return (a3 /= this.df1 * (this.df2 - 6.0) * (this.df2 - 8.0) * (this.df1 + this.df2 - 2.0) / 12.0) - 3.0;
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        SuanShuUtils.assertOrThrow(this.df2 > 2.0 ? null : new UnsupportedOperationException("only supported for df2 > 2"));
        return this.df2 / (this.df2 - 2.0);
    }

    public FDistribution(double df1, double df2) {
        SuanShuUtils.assertArgument(df1 > 0.0, "df1 must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(df2 > 0.0, "df2 must be > 0", new Object[0]);
        this.df1 = df1;
        this.df2 = df2;
        this.L = new BetaRegularized(df1 / 2.0, df2 / 2.0);
        this.E = new BetaRegularizedInverse(df1 / 2.0, df2 / 2.0);
    }

    @Override
    public double quantile(double u) {
        double a2 = this.E.evaluate(u);
        return this.df2 * a2 / (this.df1 - this.df1 * a2);
    }

    @Override
    public double skew() {
        SuanShuUtils.assertOrThrow(this.df2 > 6.0 ? null : new UnsupportedOperationException("only supported for df2 > 6"));
        double a2 = (2.0 * this.df1 + this.df2 - 2.0) * Math.sqrt(8.0 * (this.df2 - 4.0));
        return a2 /= (this.df2 - 6.0) * Math.sqrt(this.df1 * (this.df1 + this.df2 - 2.0));
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("does not exist.");
    }

    @Override
    public double variance() {
        SuanShuUtils.assertOrThrow(this.df2 > 4.0 ? null : new UnsupportedOperationException("only supported for df2 > 4"));
        double a2 = 2.0 * this.df2 * this.df2 * (this.df1 + this.df2 - 2.0);
        return a2 /= this.df1 * (this.df2 - 2.0) * (this.df2 - 2.0) * (this.df2 - 4.0);
    }

    @Override
    public double cdf(double x) {
        SuanShuUtils.assertArgument(x >= 0.0, "x must be >= 0", new Object[0]);
        return this.L.evaluate(this.df1 * x / (this.df1 * x + this.df2));
    }
}

