/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.stats.descriptive.moment.Kurtosis;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Skewness;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.descriptive.rank.Quantile;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import java.util.Arrays;

public class EmpiricalDistribution
implements UnivariateDistribution {
    private final double[] L;
    private final Quantile E;

    public EmpiricalDistribution(double[] data) {
        this(data, Quantile.QuantileType.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    @Override
    public double median() {
        return this.E.value(0.5);
    }

    public EmpiricalDistribution(double[] data, Quantile.QuantileType quantileType) {
        this.L = Arrays.copyOf(data, data.length);
        Arrays.sort(this.L);
        this.E = new Quantile(this.L, quantileType);
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] toArray() {
        return Arrays.copyOf(this.L, this.L.length);
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        int a2;
        int a3 = 0;
        int n = a2 = 0;
        while (n < this.L.length && !(x < this.L[a2])) {
            ++a3;
            n = ++a2;
        }
        return (double)a3 / (double)this.L.length;
    }

    @Override
    public double skew() {
        return new Skewness(this.L).value();
    }

    @Override
    public double kurtosis() {
        return new Kurtosis(this.L).value();
    }

    public int nSamples() {
        return this.L.length;
    }

    @Override
    public double quantile(double u) {
        return this.E.value(u);
    }

    @Override
    public double variance() {
        return new Variance(this.L, true).value();
    }

    @Override
    public double density(double x) {
        int a2 = Arrays.binarySearch(this.L, 0, this.L.length, x);
        int a3 = 0;
        if (a2 >= 0) {
            int a4;
            int n = a4 = a2;
            while (n < this.L.length && this.L[a4] == x) {
                ++a3;
                n = ++a4;
            }
            int n2 = a4 = a2 - 1;
            while (n2 > 0 && this.L[a4] == x) {
                ++a3;
                n2 = --a4;
            }
        }
        return (double)a3 / (double)this.L.length;
    }

    @Override
    public double mean() {
        return new Mean(this.L).value();
    }
}

