/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedPInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ChiSquareDistribution
implements UnivariateDistribution {
    private static final Digamma F;
    private static final GammaRegularizedP k;
    private static final LogGamma L;
    public final double k;
    private static final GammaRegularizedPInverse E;

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x, 0.0) == 0 && this.k < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.compare(x, 0.0) == 0 && this.k == 2.0) {
            return 0.5;
        }
        double a2 = Math.pow(0.5, this.k / 2.0);
        double a3 = (this.k / 2.0 - 1.0) * Math.log(x) - x / 2.0 - L.evaluate(this.k / 2.0);
        return a2 *= Math.exp(a3);
    }

    static {
        L = new LogGamma();
        k = new GammaRegularizedP();
        E = new GammaRegularizedPInverse();
        F = new Digamma();
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return k.evaluate(this.k / 2.0, x / 2.0);
    }

    public ChiSquareDistribution(double k) {
        SuanShuUtils.assertArgument(k > 0.0, "k must be > 0", new Object[0]);
        this.k = k;
    }

    @Override
    public double quantile(double u) {
        return 2.0 * E.evaluate(this.k / 2.0, u);
    }

    @Override
    public double kurtosis() {
        return 12.0 / this.k;
    }

    @Override
    public double skew() {
        return Math.sqrt(8.0 / this.k);
    }

    @Override
    public double mean() {
        return this.k;
    }

    @Override
    public double median() {
        return this.k - 0.0 + 0.0 / this.k - 0.0 / this.k / this.k;
    }

    @Override
    public double entropy() {
        return this.k / 2.0 + Math.log(2.0) + L.evaluate(this.k / 2.0) + (1.0 - this.k / 2.0) * F.evaluate(this.k / 2.0);
    }

    @Override
    public double moment(double t) {
        SuanShuUtils.assertArgument(t < 0.5, "only for t < 0.5", new Object[0]);
        return Math.pow(1.0 - 2.0 * t, -this.k / 2.0);
    }

    @Override
    public double variance() {
        return 2.0 * this.k;
    }
}

