/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class BetaDistribution
implements UnivariateDistribution {
    private static final Digamma F;
    private final BetaRegularizedInverse k;
    public final double beta;
    private final BetaRegularized L;
    private static final LogBeta E;
    public final double alpha;

    public double ccdf(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double quantile(double u) {
        return this.k.evaluate(u);
    }

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        if (DoubleUtils.compare(x, 0.0) == 0) {
            if (this.alpha < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double a2 = (this.alpha - 1.0) * Math.log(x) + (this.beta - 1.0) * Math.log(1.0 - x) - E.evaluate(this.alpha, this.beta);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double kurtosis() {
        double a2 = 6.0;
        a2 = 6.0 * (this.alpha * this.alpha * this.alpha - this.alpha * this.alpha * (2.0 * this.beta - 1.0) + this.beta * this.beta * (this.beta + 1.0) - 2.0 * this.alpha * this.beta * (this.beta + 2.0));
        return a2 /= this.alpha * this.beta * (this.alpha + this.beta + 2.0) * (this.alpha + this.beta + 3.0);
    }

    @Override
    public double entropy() {
        double a2 = E.evaluate(this.alpha, this.beta);
        a2 -= (this.alpha - 1.0) * F.evaluate(this.alpha);
        a2 -= (this.beta - 1.0) * F.evaluate(this.beta);
        return a2 += (this.alpha + this.beta - 2.0) * F.evaluate(this.alpha + this.beta);
    }

    @Override
    public double skew() {
        double a2 = this.alpha + this.beta;
        double a3 = 2.0 * (this.beta - this.alpha) * Math.sqrt(a2 + 1.0);
        return a3 /= (a2 + 2.0) * Math.sqrt(this.alpha * this.beta);
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        return this.L.evaluate(x);
    }

    @Override
    public double mean() {
        return this.alpha / (this.alpha + this.beta);
    }

    public BetaDistribution(double alpha, double beta) {
        SuanShuUtils.assertArgument(alpha > 0.0, "alpha must be > 0", new Object[0]);
        SuanShuUtils.assertArgument(beta > 0.0, "beta must be > 0", new Object[0]);
        this.alpha = alpha;
        this.beta = beta;
        this.L = new BetaRegularized(alpha, beta);
        this.k = new BetaRegularizedInverse(alpha, beta);
    }

    @Override
    public double variance() {
        double a2 = this.alpha + this.beta;
        double a3 = this.alpha * this.beta;
        return a3 /= a2 * a2 * (a2 + 1.0);
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("no closed form.");
    }

    static {
        E = new LogBeta();
        F = new Digamma();
    }
}

