/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Moments;

public class Variance
implements Statistic {
    private long k = 0L;
    public final boolean unbiased;
    private double L = 0.0;
    private Mean E = new Mean();

    @Override
    public long N() {
        return this.k;
    }

    @Override
    public double value() {
        return this.k >= 2L ? this.L / (double)(this.unbiased ? this.k - 1L : this.k) : 0.0;
    }

    @Override
    public void addData(double ... data) {
        if (this.k == 0L) {
            this.k = data.length;
            this.E.addData(data);
            this.L = Moments.sumsOfPowersOfDifferences(2, this.E.value(), data);
            return;
        }
        Variance a2 = new Variance(data, this.unbiased);
        double a3 = a2.E.value() - this.E.value();
        long a4 = this.k + a2.k;
        this.L += a2.L + a3 * a3 * ((double)this.k / (double)a4) * (double)a2.k;
        this.E.addData(data);
        this.k = a4;
    }

    public Variance(Variance that) {
        this.unbiased = that.unbiased;
        this.k = that.k;
        this.L = that.L;
        this.E = new Mean(that.E);
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.value();
        objectArray[1] = this.standardDeviation();
        objectArray[2] = this.k;
        return String.format("var: %f, stdev: %f, N: %d", objectArray);
    }

    public Variance() {
        this.unbiased = true;
    }

    public double standardDeviation() {
        return Math.sqrt(this.value());
    }

    public Variance(double[] data) {
        this.unbiased = true;
        this.addData(data);
    }

    public Variance(double[] data, boolean unbiased) {
        this.unbiased = unbiased;
        this.addData(data);
    }
}

