/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import java.util.Arrays;

public class Moments
implements Statistic {
    public final int order;
    private double[] L;
    private long E = 0L;

    public Moments(Moments that) {
        this.order = that.order;
        this.E = that.E;
        this.L = Arrays.copyOf(that.L, that.L.length);
    }

    @Override
    public double value() {
        return this.centralMoment(this.order);
    }

    public static double sumsOfPowersOfDifferences(int power, double mean, double ... data) {
        int a2;
        double a3 = 0.0;
        double[] a4 = data;
        int a5 = data.length;
        int n = a2 = 0;
        while (n < a5) {
            double a6 = a4[a2] - mean;
            a3 += power == 1 ? a6 : Math.pow(a6, power);
            n = ++a2;
        }
        return a3;
    }

    public Moments(int order) {
        this.order = order;
        this.L = new double[order];
    }

    public Moments(int order, double ... data) {
        this(order);
        this.addData(data);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        int n = a2 = 0;
        while (n < this.L.length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a2;
            objectArray[1] = this.L[a2];
            a3.append(String.format("m[%d]: %f; ", objectArray));
            n = ++a2;
        }
        return a3.toString();
    }

    @Override
    public long N() {
        return this.E;
    }

    public double centralMoment(int k) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.order;
        SuanShuUtils.assertArgument(k <= this.order, "only up to the %d moment are available", objectArray);
        return this.L[k - 1] / (double)this.E;
    }

    @Override
    public void addData(double ... data) {
        int a2;
        if (this.E == 0L) {
            int a3;
            this.E = data.length;
            this.L[0] = Moments.sumsOfPowersOfDifferences(1, 0.0, data);
            double a4 = this.L[0] / (double)this.E;
            int n = a3 = 2;
            while (n <= this.order) {
                this.L[a3 - 1] = Moments.sumsOfPowersOfDifferences(a3, a4, data);
                n = ++a3;
            }
            return;
        }
        Moments a5 = new Moments(this);
        Moments a6 = new Moments(this.order, data);
        long a7 = a5.E + a6.E;
        double a8 = a6.L[0] / (double)a6.E - a5.L[0] / (double)a5.E;
        this.L[0] = a5.L[0] + a6.L[0];
        int n = a2 = 2;
        while (n <= this.order) {
            int a9;
            double a10 = 0.0;
            int n2 = a9 = 1;
            while (true) {
                if (n2 > a2 - 2) break;
                int a11 = a2 - a9;
                double a12 = Math.pow((double)(-a6.E) / (double)a7, a9) * a5.L[a11 - 1];
                a12 += Math.pow((double)a5.E / (double)a7, a9) * a6.L[a11 - 1];
                a12 *= Math.pow(a8, a9);
                a10 += (a12 *= FunctionOps.combination(a2, a9));
                n2 = ++a9;
            }
            double a22 = (double)a5.E / (double)a7;
            a22 *= a8 * (double)a6.E;
            a22 = Math.pow(a22, a2);
            a22 *= 1.0 / Math.pow(a6.E, a2 - 1) - Math.pow(-1.0 / (double)a5.E, a2 - 1);
            this.L[a2 - 1] = a5.L[a2 - 1] + a6.L[a2 - 1] + a10 + a22;
            n = ++a2;
        }
        this.E = a7;
    }
}

