/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Moments;

public class Kurtosis
implements Statistic {
    private Moments E = new Moments(4);

    @Override
    public void addData(double ... data) {
        this.E.addData(data);
    }

    public Kurtosis() {
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.value();
        objectArray[1] = this.N();
        return String.format("kurtosis: %f; N: %d", objectArray);
    }

    public double sample() {
        double a2 = this.E.centralMoment(2);
        return this.E.centralMoment(4) / a2 / a2 - 3.0;
    }

    public Kurtosis(double[] data) {
        this.addData(data);
    }

    @Override
    public long N() {
        return this.E.N();
    }

    public Kurtosis(Kurtosis that) {
        this.E = new Moments(that.E);
    }

    @Override
    public double value() {
        double a2 = this.E.centralMoment(2) * ((double)this.N() / (double)(this.N() - 1L));
        return this.E.centralMoment(4) / a2 / a2 - 3.0;
    }
}

