/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;

public class Covariance
implements Statistic {
    private Mean i;
    private Mean G = new Mean();
    private long F = 0L;
    private Variance k;
    private double L = 0.0;
    private Variance E = new Variance();

    public void addData(double[][] data) {
        SuanShuUtils.assertArgument(data.length == 2, "there must be a pair of data", new Object[0]);
        SuanShuUtils.assertArgument(data[0].length == data[1].length, "there must be a pair of data of the same length", new Object[0]);
        if (this.F == 0L) {
            int a2;
            this.F = data[0].length;
            this.G.addData(data[0]);
            this.E.addData(data[0]);
            this.i.addData(data[1]);
            this.k.addData(data[1]);
            double a3 = this.G.value();
            double a4 = this.i.value();
            this.L = 0.0;
            int n = a2 = 0;
            while ((long)n < this.F) {
                this.L += (data[0][a2] - a3) * (data[1][a2] - a4);
                n = ++a2;
            }
            return;
        }
        Covariance a5 = new Covariance(data);
        long a6 = this.F + a5.F;
        double a7 = a5.G.value() - this.G.value();
        double a8 = a5.i.value() - this.i.value();
        double a9 = (double)this.F / (double)a6 * (double)a5.F;
        this.L += a5.L + (a9 *= a7 * a8);
        this.G.addData(data[0]);
        this.i.addData(data[1]);
        this.F = a6;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.value();
        objectArray[1] = this.correlation();
        objectArray[2] = this.F;
        return String.format("covariance: %f; correlation: %f, N: %d", objectArray);
    }

    @Override
    public void addData(double ... data) {
        SuanShuUtils.assertArgument(data.length % 2 == 0, "there must be an even number of data points", new Object[0]);
        double[][] a2 = new double[2][data.length / 2];
        int a3 = 0;
        int a4 = 0;
        int n = a3;
        while (true) {
            if (n >= data.length / 2) break;
            a2[0][a4] = data[a3];
            ++a4;
            n = ++a3;
        }
        a4 = 0;
        int n2 = a3;
        while (n2 < data.length) {
            a2[1][a4] = data[a3];
            ++a4;
            n2 = ++a3;
        }
        this.addData(a2);
    }

    @Override
    public long N() {
        return this.F;
    }

    public double correlation() {
        return this.value() / this.E.standardDeviation() / this.k.standardDeviation();
    }

    public Covariance(Covariance that) {
        this.i = new Mean();
        this.k = new Variance();
        this.F = that.F;
        this.G = that.G;
        this.E = that.E;
        this.i = that.i;
        this.k = that.k;
        this.L = that.L;
    }

    public Covariance() {
        this.i = new Mean();
        this.k = new Variance();
    }

    @Override
    public double value() {
        return this.F > 1L ? this.L / (double)(this.F - 1L) : Double.NaN;
    }

    public Covariance(double[][] data) {
        this.i = new Mean();
        this.k = new Variance();
        this.addData(data);
    }
}

