/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.signalprocessing.filter;

import com.numericalmethod.suanshu.signalprocessing.filter.Filter;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class MovingAverage
implements Filter {
    public final Side side;
    private final double[] E;

    public MovingAverage(double[] filter, Side side) {
        this.E = Arrays.copyOf(filter, filter.length);
        this.side = side;
    }

    @Override
    public double[] filtering(double[] Xt) {
        int a2;
        int a3;
        int a4;
        int a5 = Xt.length;
        int a6 = (this.E.length - 1) / 2;
        double[] a7 = new DenseVector(a5, Double.NaN).toArray();
        int n = this.side == Side.PAST ? this.E.length - 1 : (a4 = a6);
        int n2 = this.side == Side.PAST ? a5 : (a3 = a5 - this.E.length / 2);
        int a8 = this.side == Side.PAST ? this.E.length - 1 : a6;
        int n3 = a2 = a4;
        while (n3 < a3) {
            int a9;
            double a10 = 0.0;
            int n4 = a9 = 0;
            while (n4 < this.E.length) {
                a10 += Xt[a2 - a8 + a9] * this.E[this.E.length - a9 - 1];
                n4 = ++a9;
            }
            a7[a2] = a10;
            n3 = ++a2;
        }
        return a7;
    }

    public MovingAverage(double[] filter) {
        this(filter, Side.SYMMETRIC_WINDOW);
    }

    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side SYMMETRIC_WINDOW = new Side();
        private static final /* synthetic */ Side[] E;
        public static final /* enum */ Side PAST = new Side();

        public static Side[] values() {
            return (Side[])E.clone();
        }

        static {
            Side[] sideArray = new Side[2];
            sideArray[0] = SYMMETRIC_WINDOW;
            sideArray[1] = PAST;
            E = sideArray;
        }

        private Side() {
            Side a2;
        }

        public static Side valueOf(String name) {
            return Enum.valueOf(Side.class, name);
        }
    }
}

