/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate.bracketsearch;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.optimization.univariate.bracketsearch.BracketSearch;

public class Golden
extends BracketSearch {
    private final double E = 1.0 - 1.0 / Constant.GOLDEN_RATIO;

    @Override
    public double xnext() {
        Golden a2;
        double a3 = a2.xu - a2.xmin;
        double a4 = a2.xmin - a2.xl;
        double a5 = a2.xmin;
        a5 = a2.xmin + a2.E * (a3 > a4 ? a3 : -a4);
        return a5;
    }

    @Override
    public boolean isMinFound() {
        Golden a2;
        return a2.xu - a2.xl < a2.tol;
    }

    public double search(double lower, double upper) {
        double a2 = lower + this.E * (upper - lower);
        return super.search(lower, a2, upper);
    }
}

