/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate.bracketsearch;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.univariate.UnivariateMinimizer;

public abstract class BracketSearch
implements UnivariateMinimizer {
    public double xu;
    public double xl;
    public double tol;
    public double fmin;
    public int maxIterations;
    public double fnext;
    public int iter;
    public double xnext;
    public UnivariateRealFunction f;
    public double xmin;

    public abstract double xnext();

    @Override
    public void solve(UnivariateRealFunction f2, double tol, int maxIterations) {
        this.f = f2;
        double a2 = Math.sqrt(Constant.EPSILON);
        this.tol = tol < a2 ? a2 : tol;
        this.maxIterations = maxIterations;
    }

    public abstract boolean isMinFound();

    public boolean isBracketing(double a2, double a3, double a4) {
        BracketSearch a5;
        double a6 = a5.f.evaluate(a2);
        double a7 = a5.f.evaluate(a3);
        double a8 = a5.f.evaluate(a4);
        boolean a9 = false;
        if (a7 < a6 && a7 < a8) {
            a9 = true;
        }
        return a9;
    }

    public void updateStates() {
        BracketSearch a2;
        if (a2.fnext < a2.fmin) {
            if (a2.xnext < a2.xmin) {
                a2.xu = a2.xmin;
            } else {
                a2.xl = a2.xmin;
            }
            a2.xmin = a2.xnext;
            a2.fmin = a2.fnext;
        } else if (a2.xnext < a2.xmin) {
            a2.xl = a2.xnext;
        } else {
            a2.xu = a2.xnext;
        }
    }

    @Override
    public double minimum() {
        return this.fmin;
    }

    @Override
    public double search(double lower, double initial, double upper) {
        SuanShuUtils.assertArgument(lower < initial && initial < upper, "invalid bracket interval", new Object[0]);
        SuanShuUtils.assertArgument(this.isBracketing(lower, initial, upper), "the interval specified may not bracket a minimum", new Object[0]);
        this.xl = lower;
        this.xu = upper;
        this.xmin = initial;
        this.fmin = this.f.evaluate(this.xmin);
        int n = this.iter = 1;
        while (n <= this.maxIterations && !this.isMinFound()) {
            this.xnext = this.xnext();
            if (this.xnext <= this.xl || this.xu <= this.xnext) break;
            this.fnext = this.f.evaluate(this.xnext);
            this.updateStates();
            n = ++this.iter;
        }
        return 0.5 * (this.xl + this.xu);
    }
}

