/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.GradientFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.optimization.IteractiveMinimizer;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.LineSearch;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public abstract class SteepestDescent
implements IteractiveMinimizer,
UnconstrainedMinimizer {
    public RealScalarFunction f;
    private Vector k = null;
    public double maxIterations;
    private Vector L = null;
    public RealVectorFunction g;
    private SteepestDescentImpl E = null;
    public double tol;

    @Override
    public void solve(RealScalarFunction f2, double tol, int maxIterations) {
        this.solve(f2, new GradientFunction(f2), tol, maxIterations);
    }

    public abstract SteepestDescentImpl getImplementation();

    @Override
    public double minimum() {
        return this.f.evaluate(this.L.toArray());
    }

    @Override
    public Vector search(Vector ... initials) {
        int a2;
        this.L = initials[0].deepCopy();
        int n = a2 = 1;
        while ((double)n <= this.maxIterations) {
            Vector a3;
            Vector[] vectorArray = new Vector[1];
            vectorArray[0] = this.L;
            this.L = a3 = this.step(vectorArray)[0];
            if (this.k.norm() <= this.tol) break;
            n = ++a2;
        }
        return this.L.deepCopy();
    }

    public void solve(RealScalarFunction f2, RealVectorFunction g2, double tol, int maxIterations) {
        this.f = f2;
        this.g = g2;
        this.tol = tol;
        this.maxIterations = maxIterations;
        this.E = this.getImplementation();
        this.L = null;
        this.k = null;
    }

    @Override
    public Vector[] step(Vector ... initials) {
        Vector a2 = initials[0];
        Vector a3 = this.E.getDirection(a2);
        double a4 = this.E.linesearch(a2, a3);
        this.k = a3.scaled(a4);
        Vector a5 = a2.add(this.k);
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = a5;
        return vectorArray;
    }

    public abstract class SteepestDescentImpl
    implements LineSearch {
        public double ak;
        public Vector gk = null;
        public Fletcher linesearch = new Fletcher();

        public abstract Vector getDirection(Vector var1);

        public SteepestDescentImpl() {
            this.linesearch.solve(SteepestDescent.this.f, SteepestDescent.this.g);
        }

        @Override
        public double linesearch(Vector xk, Vector dk) {
            this.ak = this.linesearch.linesearch(xk, dk);
            return this.ak;
        }
    }
}

