/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.quasinewton;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.DFP;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.QuasiNewton;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class BFGS
extends QuasiNewton {
    private boolean E;

    @Override
    public SteepestDescent.SteepestDescentImpl getImplementation() {
        return new BFGSImpl(null);
    }

    public static Matrix updateHessianInverse1(Matrix S, Matrix gamma, Matrix delta) {
        Matrix a2 = gamma.t().multiply(S);
        double a3 = gamma.t().multiply(delta).get(1, 1);
        double a4 = (1.0 + a2.multiply(gamma).get(1, 1) / a3) / a3;
        Matrix a5 = delta.multiply(delta.t());
        Matrix a6 = a5.scaled(a4);
        Matrix a7 = delta.multiply(a2);
        Matrix a8 = S.multiply(gamma).multiply(delta.t());
        Matrix a9 = a7.add(a8).scaled(-1.0 / a3);
        Matrix a10 = S.add(a6).add(a9);
        return a10;
    }

    public static Matrix dampedBFGSHessianUpdate(Matrix H, Vector gamma, Vector delta) {
        double a2 = delta.innerProduct(gamma);
        double a3 = delta.innerProduct(H.multiply(delta));
        double a4 = 1.0;
        if (a2 < 0.2 * a3) {
            a4 = 0.8 * a3;
            a4 /= a3 - a2;
        }
        Vector a5 = gamma.scaled(a4);
        Vector a6 = H.multiply(delta).scaled(1.0 - a4);
        Vector a7 = a5.add(a6);
        return DFP.updateHessianInverse(H, new DenseMatrix(delta), new DenseMatrix(a7));
    }

    public static Matrix updateHessianInverse2(Matrix S, Matrix gamma, Matrix delta) {
        Matrix a2 = DFP.updateHessianInverse(new Inverse(S, 0.0), delta, gamma);
        Inverse a3 = new Inverse(a2, 0.0);
        return a3;
    }

    public void solve(boolean isFletcherSwitch, RealScalarFunction f2, RealVectorFunction g2, double tol, int maxIterations) {
        this.E = isFletcherSwitch;
        super.solve(f2, g2, tol, maxIterations);
    }

    public static class 1 {
    }

    private class BFGSImpl
    extends QuasiNewton.QuasiNewtonImpl {
        @Override
        public void updateSk(Vector a2) {
            BFGSImpl a3;
            DenseMatrix a4 = new DenseMatrix(a2);
            DenseMatrix a5 = new DenseMatrix(a3.dk.scaled(a3.ak));
            double a6 = a4.t().multiply(a5).get(1, 1);
            Matrix a7 = BFGS.updateHessianInverse1(a3.Sk, a4, a5);
            if (a3.BFGS.this.E) {
                Matrix a8 = a4.t().multiply(a7).multiply(a4);
                double a9 = a8.get(1, 1);
                if (a6 - a9 > 0.0) {
                    a7 = DFP.updateHessianInverse(a3.Sk, a4, a5);
                }
            }
            a3.Sk = a7;
        }

        private BFGSImpl() {
            BFGSImpl a2;
        }

        public /* synthetic */ BFGSImpl(1 a3) {
            a4();
            BFGSImpl a4;
        }
    }
}

