/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.initialization;

import com.numericalmethod.suanshu.algorithm.Combination;
import com.numericalmethod.suanshu.interval.DoubleInterval;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.initialization.BuildInitials;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Iterator;
import java.util.List;

public class UniformDistributionOverBox2
implements BuildInitials {
    private final Double[][] F;
    private final RandomLongGenerator k;
    private final double L;
    private final int E;

    @Override
    public Vector[] getInitials(Vector ... notused) {
        Iterator<List<Double>> a2;
        Vector[] a3 = new Vector[this.E];
        int a4 = 0;
        Iterator<List<Double>> iterator = a2 = new Combination<Double>(this.F).iterator();
        while (iterator.hasNext()) {
            List<Double> a5 = a2.next();
            a3[a4] = new DenseVector(DoubleUtils.Collection2doubleArray(a5));
            a3[a4] = this.b(a3[a4]);
            ++a4;
            iterator = a2;
        }
        return a3;
    }

    public UniformDistributionOverBox2(double scale, DoubleInterval[] bounds, int discretization) {
        this(scale, bounds, discretization, (RandomLongGenerator)new UniformRng());
    }

    public UniformDistributionOverBox2(double scale, DoubleInterval[] bounds, int discretization, RandomLongGenerator rng) {
        this(scale, bounds, R.rep(discretization, bounds.length), rng);
    }

    private Vector b(Vector a2) {
        int a3;
        Vector a4 = a2.deepCopy();
        int n = a3 = 1;
        while (n <= a4.size()) {
            UniformDistributionOverBox2 a5;
            double a6 = 1.0 - a5.L + a5.k.nextDouble() * 2.0 * a5.L;
            a4.set(a3, a4.get(a3) * a6);
            n = ++a3;
        }
        return a4;
    }

    public UniformDistributionOverBox2(double scale, DoubleInterval[] bounds, int[] discretizations) {
        this(scale, bounds, discretizations, (RandomLongGenerator)new UniformRng());
    }

    public UniformDistributionOverBox2(double scale, DoubleInterval[] bounds, int[] discretizations, RandomLongGenerator rng) {
        int a2;
        SuanShuUtils.assertArgument(bounds.length == discretizations.length, "number of bounds = number of discretizations", new Object[0]);
        this.L = scale;
        this.k = rng;
        int a3 = 1;
        this.F = new Double[bounds.length][];
        int n = a2 = 0;
        while (n < bounds.length) {
            int a4;
            this.F[a2] = new Double[discretizations[a2] - 1];
            a3 *= this.F[a2].length;
            double a5 = bounds[a2].upper() - bounds[a2].lower();
            a5 /= (double)discretizations[a2];
            int n2 = a4 = 0;
            while (true) {
                if (n2 >= discretizations[a2] - 1) break;
                this.F[a2][a4] = bounds[a2].lower() + (double)(a4 + 1) * a5;
                n2 = ++a4;
            }
            n = ++a2;
        }
        this.E = a3;
    }

    public Vector[] getInitials() {
        return this.getInitials(new Vector[0]);
    }
}

