/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.deoptim;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.deoptim.DeOptimCellFactory;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.univariate.uniform.UniformRng;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class DeRand1Bin
extends DeOptimCellFactory {
    public DeRand1Bin(double Cr, double F2, RandomLongGenerator uniform) {
        super(Cr, F2, uniform);
    }

    public DeRand1Bin(double Cr, double F2) {
        this(Cr, F2, new UniformRng());
    }

    @Override
    public DeRand1BinCell getSimpleCell(RealScalarFunction f2, double[] x) {
        return new DeRand1BinCell(f2, x);
    }

    public class DeRand1BinCell
    extends DeOptimCellFactory.DeOptimCell {
        @Override
        public DeRand1BinCell mutate() {
            DeOptimCellFactory.DeOptimCell a2;
            DeOptimCellFactory.DeOptimCell a3;
            while ((a3 = DeRand1Bin.this.getOne()) == this) {
            }
            while ((a2 = DeRand1Bin.this.getOne()) == a3 || a2 == this) {
            }
            DenseVector a4 = new DenseVector(this.x());
            DenseVector a5 = new DenseVector(a3.x());
            DenseVector a6 = new DenseVector(a2.x());
            DenseVector a7 = a5.minus(a6);
            DenseVector a8 = a4.add((DenseVector)a7.scaled(DeRand1Bin.this.F));
            return DeRand1Bin.this.getSimpleCell(this.f, a8.toArray());
        }

        @Override
        public DeRand1BinCell crossover(Chromosome obj) {
            int a2;
            double[] a3 = ((DeOptimCellFactory.DeOptimCell)obj).x();
            double[] a4 = Arrays.copyOf(this.x(), this.x().length);
            int a5 = (int)((double)a4.length * DeRand1Bin.this.uniform.nextDouble());
            a4[a5] = a3[a5];
            int n = a2 = 0;
            while (n < this.f.dimensionOfDomain()) {
                if (DeRand1Bin.this.uniform.nextDouble() <= DeRand1Bin.this.Cr) {
                    a4[a2] = a3[a2];
                }
                n = ++a2;
            }
            return DeRand1Bin.this.getSimpleCell(this.f, a4);
        }

        public DeRand1BinCell(RealScalarFunction f2, double[] x) {
            super(DeRand1Bin.this, f2, x);
        }
    }
}

