/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.deoptim;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.optimization.geneticalgorithm.minimizer.SimpleCellFactory;
import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;
import java.util.Collections;
import java.util.List;

public abstract class DeOptimCellFactory
extends SimpleCellFactory {
    public final double Cr;
    private List<Chromosome> E;
    public final double F;

    public DeOptimCellFactory(double Cr, double F2, RandomLongGenerator uniform) {
        super(F2, uniform);
        this.Cr = Cr;
        this.F = F2;
    }

    public void setPopulation(List<Chromosome> population) {
        this.E = Collections.unmodifiableList(population);
    }

    public static double Fmin(double Cr, int nPopulation) {
        double a2 = 1.0 - Cr / 2.0;
        a2 /= (double)nPopulation;
        a2 = Math.sqrt(a2);
        return a2;
    }

    public DeOptimCellFactory(DeOptimCellFactory that) {
        this(that.Cr, that.F, that.uniform);
    }

    public DeOptimCell getOne() {
        int a2 = (int)((double)this.getPopulation().size() * this.uniform.nextDouble());
        return (DeOptimCell)this.getPopulation().get(a2);
    }

    public List<Chromosome> getPopulation() {
        return this.E;
    }

    public DeOptimCell getBase() {
        return this.getOne();
    }

    public abstract class DeOptimCell
    extends SimpleCellFactory.SimpleCell {
        public DeOptimCell(RealScalarFunction f2, double[] x) {
            super(DeOptimCellFactory.this, f2, x);
        }

        @Override
        public abstract Chromosome crossover(Chromosome var1);

        @Override
        public abstract Chromosome mutate();
    }
}

