/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver;

import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPUnbounded;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SimplexPivoting;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SmallestSubscriptRule;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPBoundedSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPUnboundedSolution;

public class Phase2ByFerrisMangasarianWright
implements LPSimplexSolver {
    private LPUnbounded L = null;
    private final SimplexPivoting E;

    public Phase2ByFerrisMangasarianWright(SimplexPivoting pivoting) {
        this.E = pivoting;
    }

    @Override
    public LPSimplexSolution solve(SimplexTable table) throws LPInfeasible {
        Object a2;
        try {
            a2 = this.E.getPivot(table);
            while (a2 != null) {
                if (!table.isFeasible()) {
                    throw new LPInfeasible();
                }
                table = table.swap(((SimplexPivoting.Pivot)a2).r, ((SimplexPivoting.Pivot)a2).s);
                a2 = this.E.getPivot(table);
            }
        }
        catch (LPUnbounded a3) {
            this.L = a3;
            return new LPUnboundedSolution(table, this.L == null ? 0 : this.L.s);
        }
        a2 = new LPBoundedSolution(table);
        return a2;
    }

    public Phase2ByFerrisMangasarianWright() {
        this(new SmallestSubscriptRule());
    }
}

