/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver;

import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SmallestSubscriptRule;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolution;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LPBoundedSolution
implements LPSimplexSolution {
    private Set<MyImmutableVector> k = new HashSet<MyImmutableVector>();
    private final SimplexTable L;
    private final double E;

    @Override
    public ImmutableVector minimizer() {
        return this.k.toArray(new ImmutableVector[0])[0];
    }

    public LPBoundedSolution(SimplexTable table) {
        this.L = new SimplexTable(table);
        this.E = SuanShuUtils.autoEpsilon(table.toMatrix());
        MyImmutableVector a2 = new MyImmutableVector(this.L.minimizer());
        this.k.add(a2);
        SuanShuUtils.assertArgument(1 + this.b(table) == this.k.size(), "inconsistent logic", new Object[0]);
    }

    @Override
    public SimplexTable getResultantTableau() {
        return new SimplexTable(this.L);
    }

    @Override
    public double min() {
        return this.L.min();
    }

    public String toString() {
        Iterator<MyImmutableVector> a2;
        StringBuilder a3 = new StringBuilder();
        Object[] objectArray = new Object[1];
        objectArray[0] = this.k.size();
        a3.append(String.format("size = %d\n", objectArray));
        Iterator<MyImmutableVector> iterator = a2 = this.k.iterator();
        while (iterator.hasNext()) {
            MyImmutableVector a4 = a2.next();
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a4;
            a3.append(String.format("%s\n", objectArray2));
            iterator = a2;
        }
        return a3.toString();
    }

    private int b(SimplexTable a2) {
        int a3;
        int a4 = 0;
        int n = a3 = 1;
        while (n < a2.nCols()) {
            MyImmutableVector a5;
            SimplexTable a6;
            int a7;
            LPBoundedSolution a8;
            if (DoubleUtils.compare(a2.getCostRow(a3), 0.0, a8.E) == 0 && a2.getColLabel((int)a3).type != SimplexTable.LabelType.EQUALITY && (a7 = new SmallestSubscriptRule().ratioTest(a6 = new SimplexTable(a2), a3)) != 0 && (a6 = a6.swap(a7, a3)).isFeasible() && !a8.k.contains(a5 = a8.new MyImmutableVector(a6.minimizer()))) {
                a8.k.add(a5);
                ++a4;
                a4 += a8.b(a6);
            }
            n = ++a3;
        }
        return a4;
    }

    public ImmutableVector[] minimizers() {
        return this.k.toArray(new ImmutableVector[0]);
    }

    private class MyImmutableVector
    extends ImmutableVector {
        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Vector)) {
                return false;
            }
            Vector a2 = (Vector)obj;
            if (!AreMatrices.equal(this, a2, LPBoundedSolution.this.E)) {
                return false;
            }
            return true;
        }

        public MyImmutableVector(Vector a2) {
            MyImmutableVector a3;
            super(a2);
        }

        @Override
        public int hashCode() {
            return 7;
        }
    }
}

