/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPUnbounded;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.SimplexTable;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SmallestSubscriptRule;

public class Scheme2ByFerrisMangasarianWright {
    private SimplexTable L;
    private final double E;

    private SimplexTable m(SimplexTable a2) throws LPInfeasible {
        int a3;
        int n = a3 = 1;
        while (n < a2.nRows()) {
            if (a2.getRowLabel((int)a3).type == SimplexTable.LabelType.EQUALITY) {
                Scheme2ByFerrisMangasarianWright a4;
                double a5;
                int a6;
                int n2 = a6 = 1;
                while (n2 < a2.nCols()) {
                    if (a2.getColLabel((int)a6).type == SimplexTable.LabelType.FREE && DoubleUtils.compare(a5 = a2.get(a3, a6), 0.0, a4.E) != 0) {
                        a2 = a2.swap(a3, a6);
                        break;
                    }
                    n2 = ++a6;
                }
                if (a6 >= a2.nCols()) {
                    int n3 = a6 = 1;
                    while (n3 < a2.nCols()) {
                        if (a2.getColLabel((int)a6).type == SimplexTable.LabelType.NON_BASIC && DoubleUtils.compare(a5 = a2.get(a3, a6), 0.0, a4.E) != 0) {
                            a2 = a2.swap(a3, a6);
                            break;
                        }
                        n3 = ++a6;
                    }
                }
                if (a6 >= a2.nCols() && DoubleUtils.compare(a2.getBCol(a3), 0.0, a4.E) != 0) {
                    throw new LPInfeasible();
                }
            }
            n = ++a3;
        }
        return a2;
    }

    public SimplexTable process() throws LPInfeasible, LPUnbounded {
        SimplexTable a2 = this.m(this.L);
        return this.b(a2);
    }

    public Scheme2ByFerrisMangasarianWright(SimplexTable table) {
        this.L = new SimplexTable(table);
        this.E = SuanShuUtils.autoEpsilon(table);
    }

    private SimplexTable b(SimplexTable a2) throws LPUnbounded {
        int a3;
        SmallestSubscriptRule a4 = new SmallestSubscriptRule();
        int n = a3 = 1;
        while (n < a2.nCols()) {
            if (a2.getColLabel((int)a3).type == SimplexTable.LabelType.FREE) {
                int a5 = a4.ratioTest(a2, a3);
                if (a5 == 0) {
                    if (a2.isFeasible()) {
                        throw new LPUnbounded(a3);
                    }
                } else {
                    a2 = a2.swap(a5, a3);
                }
            }
            n = ++a3;
        }
        return a2;
    }
}

