/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex;

import com.numericalmethod.suanshu.datastructure.FlexibleTable;
import com.numericalmethod.suanshu.matrix.doubles.MatrixTable;

public class JordanExchange
extends FlexibleTable {
    public JordanExchange(MatrixTable A, int r2, int s2) {
        super(A.nRows(), A.nCols());
        int a2;
        double a3 = A.get(r2, s2);
        if (a3 == 0.0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = r2;
            objectArray[1] = s2;
            throw new RuntimeException(String.format("zero pivot found at [%d, %d] (linear dependence detected)", objectArray));
        }
        int n = a2 = 1;
        while (n <= A.nCols()) {
            this.set(r2, a2, -A.get(r2, a2) / a3);
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= A.nRows()) {
            this.set(a2, s2, A.get(a2, s2) / a3);
            n2 = ++a2;
        }
        this.set(r2, s2, 1.0 / a3);
        int n3 = a2 = 1;
        while (n3 <= A.nRows()) {
            int a4;
            int n4 = a4 = 1;
            while (n4 <= A.nCols()) {
                if (a2 != r2 && a4 != s2) {
                    this.set(a2, a4, A.get(a2, a4) - this.get(a2, s2) * A.get(r2, a4));
                }
                n4 = ++a4;
            }
            n3 = ++a2;
        }
    }

    public JordanExchange(FlexibleTable A, int r2, int s2) {
        this((MatrixTable)A, r2, s2);
        int a2;
        int n = a2 = 1;
        while (n <= this.nRows()) {
            this.renameRow(a2, A.getRowLabel(a2));
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.nCols()) {
            this.renameCol(a2, A.getColLabel(a2));
            n2 = ++a2;
        }
        Object a22 = this.getRowLabel(r2);
        this.renameRow(r2, this.getColLabel(s2));
        this.renameCol(s2, a22);
    }
}

