/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.BoxConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearLessThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.CanonicalLPProblem1;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.CanonicalLPProblem2;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class GeneralLPProblem
extends ConstrainedOptimProblem {
    private ImmutableVector L;
    private BoxConstraints E;

    @Override
    public LinearLessThanConstraints getLessThanConstraints() {
        return (LinearLessThanConstraints)super.getLessThanConstraints();
    }

    public GeneralLPProblem(CanonicalLPProblem2 problem) {
        this(problem.c(), new LinearGreaterThanConstraints(problem.A().scaled(-1.0), problem.b().scaled(-1.0)), null);
    }

    public boolean isFree(int i2) {
        if (this.E == null) {
            return false;
        }
        for (BoxConstraints.Bound a2 : this.E.getBounds()) {
            if (a2.index != i2) continue;
            if (a2.lower() == 0.0) {
                return false;
            }
            return true;
        }
        return false;
    }

    public GeneralLPProblem(Vector cost, LinearGreaterThanConstraints greater, LinearLessThanConstraints less, LinearEqualityConstraints equal, BoxConstraints bounds) {
        super(GeneralLPProblem.b(cost, greater, less, equal, bounds));
        this.L = new ImmutableVector(cost);
        this.E = bounds;
    }

    public GeneralLPProblem(Vector cost, LinearGreaterThanConstraints greater, LinearEqualityConstraints equal) {
        this(cost, greater, null, equal, null);
    }

    @Override
    public LinearEqualityConstraints getEqualityConstraints() {
        return (LinearEqualityConstraints)super.getEqualityConstraints();
    }

    private static ConstrainedOptimProblem b(final Vector a2, LinearGreaterThanConstraints a3, LinearLessThanConstraints a4, LinearEqualityConstraints a5, BoxConstraints a6) {
        if (a3 == null && a4 == null && a5 != null && a6 == null) {
            return GeneralLPProblem.b(a2, a5);
        }
        GreaterThanConstraints a7 = a4 != null ? a4.toGreaterThanConstraints() : null;
        LinearGreaterThanConstraints a8 = a6 != null ? a6.getLowerBounds() : null;
        LinearLessThanConstraints a9 = a6 != null ? a6.getUpperBounds() : null;
        GreaterThanConstraints a10 = a9 != null ? a9.toGreaterThanConstraints() : null;
        LinearConstraints[] linearConstraintsArray = new LinearConstraints[4];
        linearConstraintsArray[0] = a3;
        linearConstraintsArray[1] = a7;
        linearConstraintsArray[2] = a8;
        linearConstraintsArray[3] = a10;
        LinearLessThanConstraints a11 = ((LinearGreaterThanConstraints)LinearConstraints.concat(linearConstraintsArray)).toLessThanConstraints();
        ConstrainedOptimProblem a12 = new ConstrainedOptimProblem(new RealScalarFunction(){

            @Override
            public double evaluate(double ... z2) {
                DenseVector a22 = new DenseVector(z2);
                return a2.innerProduct(a22);
            }
            {
                1 a22;
            }

            @Override
            public int dimensionOfDomain() {
                return a2.size();
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }
        }, a5, a11);
        return a12;
    }

    public ImmutableVector b() {
        return new ImmutableVector(this.getLessThanConstraints().b().scaled(-1.0));
    }

    private static ConstrainedOptimProblem b(Vector a2, LinearEqualityConstraints a3) {
        ImmutableMatrix a4 = a3.A();
        ImmutableVector a5 = a3.b();
        Matrix[] matrixArray = new Matrix[2];
        matrixArray[0] = a4;
        matrixArray[1] = a4.scaled(-1.0);
        DenseMatrix a6 = CreateMatrix.rbind(matrixArray);
        Vector[] vectorArray = new Vector[2];
        vectorArray[0] = a5;
        vectorArray[1] = a5.scaled(-1.0);
        Vector a7 = CreateVector.concat(vectorArray);
        LinearGreaterThanConstraints a8 = new LinearGreaterThanConstraints(a6, a7);
        return GeneralLPProblem.b(a2, a8, null, null, null);
    }

    public ImmutableVector beq() {
        return this.getEqualityConstraints() != null ? ((LinearConstraints)((Object)this.getEqualityConstraints())).b() : null;
    }

    public ImmutableMatrix Aeq() {
        return this.getEqualityConstraints() != null ? ((LinearConstraints)((Object)this.getEqualityConstraints())).A() : null;
    }

    public GeneralLPProblem(CanonicalLPProblem1 problem) {
        this(problem.c(), new LinearGreaterThanConstraints(problem.A(), problem.b()), null);
    }

    @Override
    public int dimension() {
        return this.L.size();
    }

    public ImmutableVector c() {
        return this.L;
    }

    public int nGreaterThanInequalities() {
        return this.A().nRows();
    }

    public int nEqualities() {
        return this.Aeq().nRows();
    }

    public ImmutableMatrix A() {
        return new ImmutableMatrix(this.getLessThanConstraints().A().scaled(-1.0));
    }

    static {
        Package.getInstance("OPTIM").isValidated();
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("min. objective:\n");
        a3.append(this.L.toString());
        a3.append("\n");
        a3.append("less-than inequalities:\n");
        if (this.getLessThanConstraints() != null) {
            a3.append(this.getLessThanConstraints().toString());
            a3.append("\n");
        }
        a3.append("equalities:\n");
        if (this.getEqualityConstraints() != null) {
            a3.append(((LinearConstraints)((Object)this.getEqualityConstraints())).toString());
            a3.append("\n");
        }
        a3.append("free variables:\n");
        int n = a2 = 1;
        while (n <= this.dimension()) {
            if (this.isFree(a2)) {
                a3.append(a2);
                a3.append(", ");
            }
            n = ++a2;
        }
        return a3.toString();
    }
}

