/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearLessThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.EmptyLPCostVector;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPDimensionNotMatched;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.NoLPConstraint;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.CanonicalLPProblem1;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class CanonicalLPProblem2
extends ConstrainedOptimProblem {
    private final ImmutableVector E;

    public ImmutableMatrix A() {
        return this.getLessThanConstraints().A();
    }

    public ImmutableVector b() {
        return this.getLessThanConstraints().b();
    }

    public ImmutableVector c() {
        return this.E;
    }

    @Override
    public LinearLessThanConstraints getLessThanConstraints() {
        return (LinearLessThanConstraints)super.getLessThanConstraints();
    }

    public CanonicalLPProblem2(Vector cost, LinearLessThanConstraints less) {
        this(cost, less.A(), less.b());
    }

    private void m() throws EmptyLPCostVector, NoLPConstraint, LPDimensionNotMatched {
        int a2;
        CanonicalLPProblem2 a3;
        ImmutableVector a4 = a3.getLessThanConstraints().b();
        int n = a2 = 1;
        while (n <= a4.size()) {
            SuanShuUtils.assertArgument(a4.get(a2) >= 0.0, "b \u2265 0", new Object[0]);
            n = ++a2;
        }
        if (a3.E == null) {
            throw new EmptyLPCostVector();
        }
        ImmutableMatrix a22 = a3.getLessThanConstraints().A();
        if (a22 == null || a4 == null) {
            throw new NoLPConstraint();
        }
        if (a22.nRows() != a4.size()) {
            throw new LPDimensionNotMatched("dimension not matched for the inequality constraints");
        }
    }

    @Override
    public int dimension() {
        return this.E.size();
    }

    public CanonicalLPProblem2(Vector c2, Matrix A, Vector b2) {
        super(CanonicalLPProblem2.b(c2, A, b2));
        this.E = new ImmutableVector(c2);
        this.m();
    }

    static {
        Package.getInstance("OPTIM").isValidated();
    }

    private static ConstrainedOptimProblem b(final Vector a2, Matrix a3, Vector a4) {
        return new ConstrainedOptimProblem(new RealScalarFunction(){

            @Override
            public int dimensionOfDomain() {
                return a2.size();
            }

            @Override
            public double evaluate(double ... z2) {
                DenseVector a22 = new DenseVector(z2);
                return a2.innerProduct(a22);
            }
            {
                1 a22;
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }
        }, null, new LinearLessThanConstraints(a3, a4));
    }

    @Override
    public LinearEqualityConstraints getEqualityConstraints() {
        return (LinearEqualityConstraints)super.getEqualityConstraints();
    }

    public CanonicalLPProblem2(CanonicalLPProblem1 problem1) {
        this(problem1.c(), problem1.A().scaled(-1.0), problem1.b().scaled(-1.0));
    }
}

