/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.PenaltyFunction;
import java.util.Arrays;

public class SumOfPenalties
extends PenaltyFunction {
    private final PenaltyFunction[] E;

    public SumOfPenalties(PenaltyFunction ... penalties) {
        int a2;
        int a3 = penalties[0].dimensionOfDomain();
        int n = a2 = 1;
        while (n < penalties.length) {
            SuanShuUtils.assertArgument(a3 == penalties[a2].dimensionOfDomain(), "the penalties must have the same dimension", new Object[0]);
            n = ++a2;
        }
        this.E = Arrays.copyOf(penalties, penalties.length);
    }

    @Override
    public int dimensionOfDomain() {
        return this.E[0].dimensionOfDomain();
    }

    @Override
    public double evaluate(double ... x) {
        int a2;
        double a3 = 0.0;
        int n = a2 = 0;
        while (n < this.E.length) {
            a3 += this.E[a2].evaluate(x);
            n = ++a2;
        }
        return a3;
    }
}

